@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointConnectionForPrivateLinkHubBasicResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointConnectionForPrivateLinkHubBasicResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [PrivateLinkHub].
 */
@PulumiTagMarker
public class PrivateLinkHubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkHubArgs = PrivateLinkHubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkHubArgsBuilder.() -> Unit) {
        val builder = PrivateLinkHubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateLinkHub {
        val builtJavaResource = com.pulumi.azurenative.synapse.PrivateLinkHub(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateLinkHub(builtJavaResource)
    }
}

/**
 * A privateLinkHub
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a privateLinkHub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkHub = new AzureNative.Synapse.PrivateLinkHub("privateLinkHub", new()
 *     {
 *         Location = "East US",
 *         PrivateLinkHubName = "privateLinkHub1",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewPrivateLinkHub(ctx, "privateLinkHub", &synapse.PrivateLinkHubArgs{
 * 			Location:           pulumi.String("East US"),
 * 			PrivateLinkHubName: pulumi.String("privateLinkHub1"),
 * 			ResourceGroupName:  pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.PrivateLinkHub;
 * import com.pulumi.azurenative.synapse.PrivateLinkHubArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkHub = new PrivateLinkHub("privateLinkHub", PrivateLinkHubArgs.builder()
 *             .location("East US")
 *             .privateLinkHubName("privateLinkHub1")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:PrivateLinkHub privateLinkHub1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}
 * ```
 */
public class PrivateLinkHub internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.PrivateLinkHub,
) : KotlinCustomResource(javaResource, PrivateLinkHubMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections
     */
    public val privateEndpointConnections:
        Output<List<PrivateEndpointConnectionForPrivateLinkHubBasicResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * PrivateLinkHub provisioning state
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkHubMapper : ResourceMapper<PrivateLinkHub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.PrivateLinkHub::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkHub = PrivateLinkHub(
        javaResource as
            com.pulumi.azurenative.synapse.PrivateLinkHub,
    )
}

/**
 * @see [PrivateLinkHub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkHub].
 */
public suspend fun privateLinkHub(
    name: String,
    block: suspend PrivateLinkHubResourceBuilder.() -> Unit,
): PrivateLinkHub {
    val builder = PrivateLinkHubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkHub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkHub(name: String): PrivateLinkHub {
    val builder = PrivateLinkHubResourceBuilder()
    builder.name(name)
    return builder.build()
}
