@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.ReadWriteDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a read write database.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDatabasesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readWriteDatabase = new AzureNative.Synapse.ReadWriteDatabase("readWriteDatabase", new()
 *     {
 *         DatabaseName = "KustoDatabase8",
 *         Kind = "ReadWrite",
 *         KustoPoolName = "kustoclusterrptest4",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         SoftDeletePeriod = "P1D",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewReadWriteDatabase(ctx, "readWriteDatabase", &synapse.ReadWriteDatabaseArgs{
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			Kind:              pulumi.String("ReadWrite"),
 * 			KustoPoolName:     pulumi.String("kustoclusterrptest4"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 			SoftDeletePeriod:  pulumi.String("P1D"),
 * 			WorkspaceName:     pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.ReadWriteDatabase;
 * import com.pulumi.azurenative.synapse.ReadWriteDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readWriteDatabase = new ReadWriteDatabase("readWriteDatabase", ReadWriteDatabaseArgs.builder()
 *             .databaseName("KustoDatabase8")
 *             .kind("ReadWrite")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .softDeletePeriod("P1D")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:ReadWriteDatabase KustoClusterRPTest4/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}
 * ```
 * @property databaseName The name of the database in the Kusto pool.
 * @property hotCachePeriod The time the data should be kept in cache for fast queries in TimeSpan.
 * @property kind Kind of the database
 * Expected value is 'ReadWrite'.
 * @property kustoPoolName The name of the Kusto pool.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property softDeletePeriod The time the data should be kept before it stops being accessible to queries in TimeSpan.
 * @property workspaceName The name of the workspace.
 */
public data class ReadWriteDatabaseArgs(
    public val databaseName: Output<String>? = null,
    public val hotCachePeriod: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val softDeletePeriod: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.ReadWriteDatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.ReadWriteDatabaseArgs =
        com.pulumi.azurenative.synapse.ReadWriteDatabaseArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .hotCachePeriod(hotCachePeriod?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .softDeletePeriod(softDeletePeriod?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReadWriteDatabaseArgs].
 */
@PulumiTagMarker
public class ReadWriteDatabaseArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var hotCachePeriod: Output<String>? = null

    private var kind: Output<String>? = null

    private var kustoPoolName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var softDeletePeriod: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("deyvynukuncmdhxy")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("etdxountajlrfxpt")
    public suspend fun hotCachePeriod(`value`: Output<String>) {
        this.hotCachePeriod = value
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadWrite'.
     */
    @JvmName("wyuordxvgpbfkvfd")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("nefuiglhunoufwla")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("yneecbyakexxurag")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hpelyibqenxuhtuf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The time the data should be kept before it stops being accessible to queries in TimeSpan.
     */
    @JvmName("opxdpcbrsnctjmqb")
    public suspend fun softDeletePeriod(`value`: Output<String>) {
        this.softDeletePeriod = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ksuwdstqqnnnohxf")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("jnyhgpmjdmivuodr")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("bdwheylvnxcpkuhv")
    public suspend fun hotCachePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hotCachePeriod = mapped
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadWrite'.
     */
    @JvmName("rcksbnvgkqdhueyf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("lrdggewinrxpywak")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gdtskhxavqhpjgix")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lbalodlpdpcekeqp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The time the data should be kept before it stops being accessible to queries in TimeSpan.
     */
    @JvmName("pxbtmtepnuujmhxt")
    public suspend fun softDeletePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeletePeriod = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("sgyxhnqnuhlpsdjd")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ReadWriteDatabaseArgs = ReadWriteDatabaseArgs(
        databaseName = databaseName,
        hotCachePeriod = hotCachePeriod,
        kind = kind,
        kustoPoolName = kustoPoolName,
        location = location,
        resourceGroupName = resourceGroupName,
        softDeletePeriod = softDeletePeriod,
        workspaceName = workspaceName,
    )
}
