@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SqlPool].
 */
@PulumiTagMarker
public class SqlPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlPoolArgs = SqlPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlPoolArgsBuilder.() -> Unit) {
        val builder = SqlPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlPool {
        val builtJavaResource = com.pulumi.azurenative.synapse.SqlPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SqlPool(builtJavaResource)
    }
}

/**
 * A SQL Analytics pool
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-05-01, 2021-06-01-preview.
 * ## Example Usage
 * ### Create a SQL Analytics pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPool = new AzureNative.Synapse.SqlPool("sqlPool", new()
 *     {
 *         Collation = "",
 *         CreateMode = "",
 *         Location = "Southeast Asia",
 *         MaxSizeBytes = 0,
 *         RecoverableDatabaseId = "",
 *         ResourceGroupName = "ExampleResourceGroup",
 *         Sku = new AzureNative.Synapse.Inputs.SkuArgs
 *         {
 *             Name = "",
 *             Tier = "",
 *         },
 *         SourceDatabaseId = "",
 *         SqlPoolName = "ExampleSqlPool",
 *         StorageAccountType = AzureNative.Synapse.StorageAccountType.LRS,
 *         Tags = null,
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPool(ctx, "sqlPool", &synapse.SqlPoolArgs{
 * 			Collation:             pulumi.String(""),
 * 			CreateMode:            pulumi.String(""),
 * 			Location:              pulumi.String("Southeast Asia"),
 * 			MaxSizeBytes:          pulumi.Float64(0),
 * 			RecoverableDatabaseId: pulumi.String(""),
 * 			ResourceGroupName:     pulumi.String("ExampleResourceGroup"),
 * 			Sku: &synapse.SkuArgs{
 * 				Name: pulumi.String(""),
 * 				Tier: pulumi.String(""),
 * 			},
 * 			SourceDatabaseId:   pulumi.String(""),
 * 			SqlPoolName:        pulumi.String("ExampleSqlPool"),
 * 			StorageAccountType: pulumi.String(synapse.StorageAccountTypeLRS),
 * 			Tags:               nil,
 * 			WorkspaceName:      pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPool;
 * import com.pulumi.azurenative.synapse.SqlPoolArgs;
 * import com.pulumi.azurenative.synapse.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPool = new SqlPool("sqlPool", SqlPoolArgs.builder()
 *             .collation("")
 *             .createMode("")
 *             .location("Southeast Asia")
 *             .maxSizeBytes(0)
 *             .recoverableDatabaseId("")
 *             .resourceGroupName("ExampleResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("")
 *                 .tier("")
 *                 .build())
 *             .sourceDatabaseId("")
 *             .sqlPoolName("ExampleSqlPool")
 *             .storageAccountType("LRS")
 *             .tags()
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPool ExampleSqlPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}
 * ```
 */
public class SqlPool internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.SqlPool,
) : KotlinCustomResource(javaResource, SqlPoolMapper) {
    /**
     * Collation mode
     */
    public val collation: Output<String>?
        get() = javaResource.collation().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date the SQL pool was created
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maximum size in bytes
     */
    public val maxSizeBytes: Output<Double>?
        get() = javaResource.maxSizeBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource state
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Backup database to restore from
     */
    public val recoverableDatabaseId: Output<String>?
        get() = javaResource.recoverableDatabaseId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Snapshot time to restore
     */
    public val restorePointInTime: Output<String>?
        get() = javaResource.restorePointInTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL pool SKU
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the time that the sql pool was deleted
     */
    public val sourceDatabaseDeletionDate: Output<String>?
        get() = javaResource.sourceDatabaseDeletionDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource status
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The storage account type used to store backups for this sql pool.
     */
    public val storageAccountType: Output<String>?
        get() = javaResource.storageAccountType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlPoolMapper : ResourceMapper<SqlPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.SqlPool::class == javaResource::class

    override fun map(javaResource: Resource): SqlPool = SqlPool(
        javaResource as
            com.pulumi.azurenative.synapse.SqlPool,
    )
}

/**
 * @see [SqlPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlPool].
 */
public suspend fun sqlPool(name: String, block: suspend SqlPoolResourceBuilder.() -> Unit):
    SqlPool {
    val builder = SqlPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlPool(name: String): SqlPool {
    val builder = SqlPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
