@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SqlPoolArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.CreateMode
import com.pulumi.azurenative.synapse.kotlin.enums.StorageAccountType
import com.pulumi.azurenative.synapse.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SQL Analytics pool
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-05-01, 2021-06-01-preview.
 * ## Example Usage
 * ### Create a SQL Analytics pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPool = new AzureNative.Synapse.SqlPool("sqlPool", new()
 *     {
 *         Collation = "",
 *         CreateMode = "",
 *         Location = "Southeast Asia",
 *         MaxSizeBytes = 0,
 *         RecoverableDatabaseId = "",
 *         ResourceGroupName = "ExampleResourceGroup",
 *         Sku = new AzureNative.Synapse.Inputs.SkuArgs
 *         {
 *             Name = "",
 *             Tier = "",
 *         },
 *         SourceDatabaseId = "",
 *         SqlPoolName = "ExampleSqlPool",
 *         StorageAccountType = AzureNative.Synapse.StorageAccountType.LRS,
 *         Tags = null,
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPool(ctx, "sqlPool", &synapse.SqlPoolArgs{
 * 			Collation:             pulumi.String(""),
 * 			CreateMode:            pulumi.String(""),
 * 			Location:              pulumi.String("Southeast Asia"),
 * 			MaxSizeBytes:          pulumi.Float64(0),
 * 			RecoverableDatabaseId: pulumi.String(""),
 * 			ResourceGroupName:     pulumi.String("ExampleResourceGroup"),
 * 			Sku: &synapse.SkuArgs{
 * 				Name: pulumi.String(""),
 * 				Tier: pulumi.String(""),
 * 			},
 * 			SourceDatabaseId:   pulumi.String(""),
 * 			SqlPoolName:        pulumi.String("ExampleSqlPool"),
 * 			StorageAccountType: pulumi.String(synapse.StorageAccountTypeLRS),
 * 			Tags:               nil,
 * 			WorkspaceName:      pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPool;
 * import com.pulumi.azurenative.synapse.SqlPoolArgs;
 * import com.pulumi.azurenative.synapse.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPool = new SqlPool("sqlPool", SqlPoolArgs.builder()
 *             .collation("")
 *             .createMode("")
 *             .location("Southeast Asia")
 *             .maxSizeBytes(0)
 *             .recoverableDatabaseId("")
 *             .resourceGroupName("ExampleResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("")
 *                 .tier("")
 *                 .build())
 *             .sourceDatabaseId("")
 *             .sqlPoolName("ExampleSqlPool")
 *             .storageAccountType("LRS")
 *             .tags()
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPool ExampleSqlPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}
 * ```
 * @property collation Collation mode
 * @property createMode Specifies the mode of sql pool creation.
 * Default: regular sql pool creation.
 * PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
 * Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
 * Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
 * @property location The geo-location where the resource lives
 * @property maxSizeBytes Maximum size in bytes
 * @property provisioningState Resource state
 * @property recoverableDatabaseId Backup database to restore from
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property restorePointInTime Snapshot time to restore
 * @property sku SQL pool SKU
 * @property sourceDatabaseDeletionDate Specifies the time that the sql pool was deleted
 * @property sourceDatabaseId Source database to create from
 * @property sqlPoolName SQL pool name
 * @property storageAccountType The storage account type used to store backups for this sql pool.
 * @property tags Resource tags.
 * @property workspaceName The name of the workspace.
 */
public data class SqlPoolArgs(
    public val collation: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val location: Output<String>? = null,
    public val maxSizeBytes: Output<Double>? = null,
    public val provisioningState: Output<String>? = null,
    public val recoverableDatabaseId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restorePointInTime: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val sourceDatabaseDeletionDate: Output<String>? = null,
    public val sourceDatabaseId: Output<String>? = null,
    public val sqlPoolName: Output<String>? = null,
    public val storageAccountType: Output<Either<String, StorageAccountType>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.SqlPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.SqlPoolArgs =
        com.pulumi.azurenative.synapse.SqlPoolArgs.builder()
            .collation(collation?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .maxSizeBytes(maxSizeBytes?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .recoverableDatabaseId(recoverableDatabaseId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restorePointInTime(restorePointInTime?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceDatabaseDeletionDate(sourceDatabaseDeletionDate?.applyValue({ args0 -> args0 }))
            .sourceDatabaseId(sourceDatabaseId?.applyValue({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName?.applyValue({ args0 -> args0 }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPoolArgs].
 */
@PulumiTagMarker
public class SqlPoolArgsBuilder internal constructor() {
    private var collation: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var location: Output<String>? = null

    private var maxSizeBytes: Output<Double>? = null

    private var provisioningState: Output<String>? = null

    private var recoverableDatabaseId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var restorePointInTime: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var sourceDatabaseDeletionDate: Output<String>? = null

    private var sourceDatabaseId: Output<String>? = null

    private var sqlPoolName: Output<String>? = null

    private var storageAccountType: Output<Either<String, StorageAccountType>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Collation mode
     */
    @JvmName("ykpsdlrklvrmqxoh")
    public suspend fun collation(`value`: Output<String>) {
        this.collation = value
    }

    /**
     * @param value Specifies the mode of sql pool creation.
     * Default: regular sql pool creation.
     * PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
     * Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
     * Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
     */
    @JvmName("oqppvkvcwlweoihi")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("oxapxxocascmsmct")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maximum size in bytes
     */
    @JvmName("lrjhbykrfyiqdgdu")
    public suspend fun maxSizeBytes(`value`: Output<Double>) {
        this.maxSizeBytes = value
    }

    /**
     * @param value Resource state
     */
    @JvmName("nertyashorrrgbyv")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value Backup database to restore from
     */
    @JvmName("esyfiptewlwssbqt")
    public suspend fun recoverableDatabaseId(`value`: Output<String>) {
        this.recoverableDatabaseId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ppwhkkgnadsrjssf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Snapshot time to restore
     */
    @JvmName("lcppagttrsipfwqy")
    public suspend fun restorePointInTime(`value`: Output<String>) {
        this.restorePointInTime = value
    }

    /**
     * @param value SQL pool SKU
     */
    @JvmName("nvtbxdcgruanuyvu")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Specifies the time that the sql pool was deleted
     */
    @JvmName("xfgsvdlnolxjekdk")
    public suspend fun sourceDatabaseDeletionDate(`value`: Output<String>) {
        this.sourceDatabaseDeletionDate = value
    }

    /**
     * @param value Source database to create from
     */
    @JvmName("dhloyrcdhgwpnlpf")
    public suspend fun sourceDatabaseId(`value`: Output<String>) {
        this.sourceDatabaseId = value
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("jascfvadxoikupbs")
    public suspend fun sqlPoolName(`value`: Output<String>) {
        this.sqlPoolName = value
    }

    /**
     * @param value The storage account type used to store backups for this sql pool.
     */
    @JvmName("mfwjwfgcaaheqhfg")
    public suspend fun storageAccountType(`value`: Output<Either<String, StorageAccountType>>) {
        this.storageAccountType = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ecnxqunlxgvtjceb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fydwnkaskbsxswuq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Collation mode
     */
    @JvmName("xlcrkwuokbiacnhs")
    public suspend fun collation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collation = mapped
    }

    /**
     * @param value Specifies the mode of sql pool creation.
     * Default: regular sql pool creation.
     * PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
     * Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
     * Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
     */
    @JvmName("mhjqusmynewwntrb")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Specifies the mode of sql pool creation.
     * Default: regular sql pool creation.
     * PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
     * Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
     * Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
     */
    @JvmName("hapbcnkknwxexhgs")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Specifies the mode of sql pool creation.
     * Default: regular sql pool creation.
     * PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
     * Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
     * Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
     */
    @JvmName("urtlprqmnghqvnmv")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("suykprlmwsrboxfs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maximum size in bytes
     */
    @JvmName("nmqbrpgkxrhptgvt")
    public suspend fun maxSizeBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSizeBytes = mapped
    }

    /**
     * @param value Resource state
     */
    @JvmName("megafnnbaerjappy")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Backup database to restore from
     */
    @JvmName("bhikcldeqvfdgmrm")
    public suspend fun recoverableDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoverableDatabaseId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qxmdhaeetdysxtyn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Snapshot time to restore
     */
    @JvmName("wopeksypbuwtnqfq")
    public suspend fun restorePointInTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePointInTime = mapped
    }

    /**
     * @param value SQL pool SKU
     */
    @JvmName("datxjiugnigmungi")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SQL pool SKU
     */
    @JvmName("oocvryxdbtfugurk")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Specifies the time that the sql pool was deleted
     */
    @JvmName("ntoklyxjrjherpms")
    public suspend fun sourceDatabaseDeletionDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDatabaseDeletionDate = mapped
    }

    /**
     * @param value Source database to create from
     */
    @JvmName("kanaaskuhgjcaohl")
    public suspend fun sourceDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDatabaseId = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("oxmvfqsseohmmaqv")
    public suspend fun sqlPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The storage account type used to store backups for this sql pool.
     */
    @JvmName("xeembypifqqorbnk")
    public suspend fun storageAccountType(`value`: Either<String, StorageAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value The storage account type used to store backups for this sql pool.
     */
    @JvmName("uhcchokvujqbujdk")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value The storage account type used to store backups for this sql pool.
     */
    @JvmName("pblnjhartxsetfgi")
    public fun storageAccountType(`value`: StorageAccountType) {
        val toBeMapped = Either.ofRight<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nttfcevrnmqshrcp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wlmygjpybvcearpi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("btwmsuyjbuouqens")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SqlPoolArgs = SqlPoolArgs(
        collation = collation,
        createMode = createMode,
        location = location,
        maxSizeBytes = maxSizeBytes,
        provisioningState = provisioningState,
        recoverableDatabaseId = recoverableDatabaseId,
        resourceGroupName = resourceGroupName,
        restorePointInTime = restorePointInTime,
        sku = sku,
        sourceDatabaseDeletionDate = sourceDatabaseDeletionDate,
        sourceDatabaseId = sourceDatabaseId,
        sqlPoolName = sqlPoolName,
        storageAccountType = storageAccountType,
        tags = tags,
        workspaceName = workspaceName,
    )
}
