@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlPoolSensitivityLabel].
 */
@PulumiTagMarker
public class SqlPoolSensitivityLabelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlPoolSensitivityLabelArgs = SqlPoolSensitivityLabelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlPoolSensitivityLabelArgsBuilder.() -> Unit) {
        val builder = SqlPoolSensitivityLabelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlPoolSensitivityLabel {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.SqlPoolSensitivityLabel(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlPoolSensitivityLabel(builtJavaResource)
    }
}

/**
 * A sensitivity label.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Updates the sensitivity label of a given column with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolSensitivityLabel = new AzureNative.Synapse.SqlPoolSensitivityLabel("sqlPoolSensitivityLabel", new()
 *     {
 *         ColumnName = "myColumn",
 *         InformationType = "PhoneNumber",
 *         InformationTypeId = "d22fa6e9-5ee4-3bde-4c2b-a409604c4646",
 *         LabelId = "bf91e08c-f4f0-478a-b016-25164b2a65ff",
 *         LabelName = "PII",
 *         ResourceGroupName = "myRG",
 *         SchemaName = "dbo",
 *         SensitivityLabelSource = "current",
 *         SqlPoolName = "myDatabase",
 *         TableName = "myTable",
 *         WorkspaceName = "myServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolSensitivityLabel(ctx, "sqlPoolSensitivityLabel", &synapse.SqlPoolSensitivityLabelArgs{
 * 			ColumnName:             pulumi.String("myColumn"),
 * 			InformationType:        pulumi.String("PhoneNumber"),
 * 			InformationTypeId:      pulumi.String("d22fa6e9-5ee4-3bde-4c2b-a409604c4646"),
 * 			LabelId:                pulumi.String("bf91e08c-f4f0-478a-b016-25164b2a65ff"),
 * 			LabelName:              pulumi.String("PII"),
 * 			ResourceGroupName:      pulumi.String("myRG"),
 * 			SchemaName:             pulumi.String("dbo"),
 * 			SensitivityLabelSource: pulumi.String("current"),
 * 			SqlPoolName:            pulumi.String("myDatabase"),
 * 			TableName:              pulumi.String("myTable"),
 * 			WorkspaceName:          pulumi.String("myServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolSensitivityLabel;
 * import com.pulumi.azurenative.synapse.SqlPoolSensitivityLabelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolSensitivityLabel = new SqlPoolSensitivityLabel("sqlPoolSensitivityLabel", SqlPoolSensitivityLabelArgs.builder()
 *             .columnName("myColumn")
 *             .informationType("PhoneNumber")
 *             .informationTypeId("d22fa6e9-5ee4-3bde-4c2b-a409604c4646")
 *             .labelId("bf91e08c-f4f0-478a-b016-25164b2a65ff")
 *             .labelName("PII")
 *             .resourceGroupName("myRG")
 *             .schemaName("dbo")
 *             .sensitivityLabelSource("current")
 *             .sqlPoolName("myDatabase")
 *             .tableName("myTable")
 *             .workspaceName("myServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolSensitivityLabel current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}
 * ```
 */
public class SqlPoolSensitivityLabel internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.SqlPoolSensitivityLabel,
) : KotlinCustomResource(javaResource, SqlPoolSensitivityLabelMapper) {
    /**
     * The column name.
     */
    public val columnName: Output<String>
        get() = javaResource.columnName().applyValue({ args0 -> args0 })

    /**
     * The information type.
     */
    public val informationType: Output<String>?
        get() = javaResource.informationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The information type ID.
     */
    public val informationTypeId: Output<String>?
        get() = javaResource.informationTypeId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
     */
    public val isDisabled: Output<Boolean>
        get() = javaResource.isDisabled().applyValue({ args0 -> args0 })

    /**
     * The label ID.
     */
    public val labelId: Output<String>?
        get() = javaResource.labelId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The label name.
     */
    public val labelName: Output<String>?
        get() = javaResource.labelName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * managed by
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val rank: Output<String>?
        get() = javaResource.rank().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The schema name.
     */
    public val schemaName: Output<String>
        get() = javaResource.schemaName().applyValue({ args0 -> args0 })

    /**
     * The table name.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlPoolSensitivityLabelMapper : ResourceMapper<SqlPoolSensitivityLabel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.SqlPoolSensitivityLabel::class == javaResource::class

    override fun map(javaResource: Resource): SqlPoolSensitivityLabel =
        SqlPoolSensitivityLabel(
            javaResource as
                com.pulumi.azurenative.synapse.SqlPoolSensitivityLabel,
        )
}

/**
 * @see [SqlPoolSensitivityLabel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlPoolSensitivityLabel].
 */
public suspend fun sqlPoolSensitivityLabel(
    name: String,
    block: suspend SqlPoolSensitivityLabelResourceBuilder.() -> Unit,
): SqlPoolSensitivityLabel {
    val builder = SqlPoolSensitivityLabelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlPoolSensitivityLabel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlPoolSensitivityLabel(name: String): SqlPoolSensitivityLabel {
    val builder = SqlPoolSensitivityLabelResourceBuilder()
    builder.name(name)
    return builder.build()
}
