@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SqlPoolSensitivityLabelArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.SensitivityLabelRank
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A sensitivity label.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Updates the sensitivity label of a given column with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolSensitivityLabel = new AzureNative.Synapse.SqlPoolSensitivityLabel("sqlPoolSensitivityLabel", new()
 *     {
 *         ColumnName = "myColumn",
 *         InformationType = "PhoneNumber",
 *         InformationTypeId = "d22fa6e9-5ee4-3bde-4c2b-a409604c4646",
 *         LabelId = "bf91e08c-f4f0-478a-b016-25164b2a65ff",
 *         LabelName = "PII",
 *         ResourceGroupName = "myRG",
 *         SchemaName = "dbo",
 *         SensitivityLabelSource = "current",
 *         SqlPoolName = "myDatabase",
 *         TableName = "myTable",
 *         WorkspaceName = "myServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolSensitivityLabel(ctx, "sqlPoolSensitivityLabel", &synapse.SqlPoolSensitivityLabelArgs{
 * 			ColumnName:             pulumi.String("myColumn"),
 * 			InformationType:        pulumi.String("PhoneNumber"),
 * 			InformationTypeId:      pulumi.String("d22fa6e9-5ee4-3bde-4c2b-a409604c4646"),
 * 			LabelId:                pulumi.String("bf91e08c-f4f0-478a-b016-25164b2a65ff"),
 * 			LabelName:              pulumi.String("PII"),
 * 			ResourceGroupName:      pulumi.String("myRG"),
 * 			SchemaName:             pulumi.String("dbo"),
 * 			SensitivityLabelSource: pulumi.String("current"),
 * 			SqlPoolName:            pulumi.String("myDatabase"),
 * 			TableName:              pulumi.String("myTable"),
 * 			WorkspaceName:          pulumi.String("myServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolSensitivityLabel;
 * import com.pulumi.azurenative.synapse.SqlPoolSensitivityLabelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolSensitivityLabel = new SqlPoolSensitivityLabel("sqlPoolSensitivityLabel", SqlPoolSensitivityLabelArgs.builder()
 *             .columnName("myColumn")
 *             .informationType("PhoneNumber")
 *             .informationTypeId("d22fa6e9-5ee4-3bde-4c2b-a409604c4646")
 *             .labelId("bf91e08c-f4f0-478a-b016-25164b2a65ff")
 *             .labelName("PII")
 *             .resourceGroupName("myRG")
 *             .schemaName("dbo")
 *             .sensitivityLabelSource("current")
 *             .sqlPoolName("myDatabase")
 *             .tableName("myTable")
 *             .workspaceName("myServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolSensitivityLabel current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}
 * ```
 * @property columnName The name of the column.
 * @property informationType The information type.
 * @property informationTypeId The information type ID.
 * @property labelId The label ID.
 * @property labelName The label name.
 * @property rank
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schemaName The name of the schema.
 * @property sensitivityLabelSource The source of the sensitivity label.
 * @property sqlPoolName SQL pool name
 * @property tableName The name of the table.
 * @property workspaceName The name of the workspace.
 */
public data class SqlPoolSensitivityLabelArgs(
    public val columnName: Output<String>? = null,
    public val informationType: Output<String>? = null,
    public val informationTypeId: Output<String>? = null,
    public val labelId: Output<String>? = null,
    public val labelName: Output<String>? = null,
    public val rank: Output<SensitivityLabelRank>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val sensitivityLabelSource: Output<String>? = null,
    public val sqlPoolName: Output<String>? = null,
    public val tableName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.SqlPoolSensitivityLabelArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.SqlPoolSensitivityLabelArgs =
        com.pulumi.azurenative.synapse.SqlPoolSensitivityLabelArgs.builder()
            .columnName(columnName?.applyValue({ args0 -> args0 }))
            .informationType(informationType?.applyValue({ args0 -> args0 }))
            .informationTypeId(informationTypeId?.applyValue({ args0 -> args0 }))
            .labelId(labelId?.applyValue({ args0 -> args0 }))
            .labelName(labelName?.applyValue({ args0 -> args0 }))
            .rank(rank?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .sensitivityLabelSource(sensitivityLabelSource?.applyValue({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPoolSensitivityLabelArgs].
 */
@PulumiTagMarker
public class SqlPoolSensitivityLabelArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var informationType: Output<String>? = null

    private var informationTypeId: Output<String>? = null

    private var labelId: Output<String>? = null

    private var labelName: Output<String>? = null

    private var rank: Output<SensitivityLabelRank>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var sensitivityLabelSource: Output<String>? = null

    private var sqlPoolName: Output<String>? = null

    private var tableName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the column.
     */
    @JvmName("ihmbrjwtkdhkjyjw")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value The information type.
     */
    @JvmName("jpmfmeqafbvcyxph")
    public suspend fun informationType(`value`: Output<String>) {
        this.informationType = value
    }

    /**
     * @param value The information type ID.
     */
    @JvmName("gvdxosoqsjlewatl")
    public suspend fun informationTypeId(`value`: Output<String>) {
        this.informationTypeId = value
    }

    /**
     * @param value The label ID.
     */
    @JvmName("tuchnaskhulqueaj")
    public suspend fun labelId(`value`: Output<String>) {
        this.labelId = value
    }

    /**
     * @param value The label name.
     */
    @JvmName("dovjbhnokpkwovxx")
    public suspend fun labelName(`value`: Output<String>) {
        this.labelName = value
    }

    /**
     * @param value
     */
    @JvmName("wnlqigdoidpvkpdy")
    public suspend fun rank(`value`: Output<SensitivityLabelRank>) {
        this.rank = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nxvgfvgogibbtgev")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the schema.
     */
    @JvmName("ywxxifqebeujprfe")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The source of the sensitivity label.
     */
    @JvmName("hauunhhoqvdwxisa")
    public suspend fun sensitivityLabelSource(`value`: Output<String>) {
        this.sensitivityLabelSource = value
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("jduvvfspbvyslvov")
    public suspend fun sqlPoolName(`value`: Output<String>) {
        this.sqlPoolName = value
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("tjofvxnwwtahvgae")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("jwxfuaovkmyqokyu")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the column.
     */
    @JvmName("hnvafbcynufoqcfw")
    public suspend fun columnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value The information type.
     */
    @JvmName("vwiomllvdttqgskt")
    public suspend fun informationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.informationType = mapped
    }

    /**
     * @param value The information type ID.
     */
    @JvmName("cjcbktyapcdpirbd")
    public suspend fun informationTypeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.informationTypeId = mapped
    }

    /**
     * @param value The label ID.
     */
    @JvmName("smxahnkfumijneve")
    public suspend fun labelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelId = mapped
    }

    /**
     * @param value The label name.
     */
    @JvmName("fvbcmowkqifxyewl")
    public suspend fun labelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelName = mapped
    }

    /**
     * @param value
     */
    @JvmName("laaebdkhxgxominq")
    public suspend fun rank(`value`: SensitivityLabelRank?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rank = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qllspnqshslpftqb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schema.
     */
    @JvmName("rddvlojhvpwxkgiy")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The source of the sensitivity label.
     */
    @JvmName("aqpxaghkosnduxon")
    public suspend fun sensitivityLabelSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sensitivityLabelSource = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("jpopaolkhdmcayok")
    public suspend fun sqlPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("lfwdkomuuiqvawlh")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("xlqxegpbjanqmrdn")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SqlPoolSensitivityLabelArgs = SqlPoolSensitivityLabelArgs(
        columnName = columnName,
        informationType = informationType,
        informationTypeId = informationTypeId,
        labelId = labelId,
        labelName = labelName,
        rank = rank,
        resourceGroupName = resourceGroupName,
        schemaName = schemaName,
        sensitivityLabelSource = sensitivityLabelSource,
        sqlPoolName = sqlPoolName,
        tableName = tableName,
        workspaceName = workspaceName,
    )
}
