@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryptionArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.TransparentDataEncryptionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Sql pool transparent data encryption configuration.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a Sql pool's transparent data encryption configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolTransparentDataEncryption = new AzureNative.Synapse.SqlPoolTransparentDataEncryption("sqlPoolTransparentDataEncryption", new()
 *     {
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         Status = AzureNative.Synapse.TransparentDataEncryptionStatus.Enabled,
 *         TransparentDataEncryptionName = "current",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolTransparentDataEncryption(ctx, "sqlPoolTransparentDataEncryption", &synapse.SqlPoolTransparentDataEncryptionArgs{
 * 			ResourceGroupName:             pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:                   pulumi.String("sqlcrudtest-9187"),
 * 			Status:                        pulumi.String(synapse.TransparentDataEncryptionStatusEnabled),
 * 			TransparentDataEncryptionName: pulumi.String("current"),
 * 			WorkspaceName:                 pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryption;
 * import com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolTransparentDataEncryption = new SqlPoolTransparentDataEncryption("sqlPoolTransparentDataEncryption", SqlPoolTransparentDataEncryptionArgs.builder()
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .status("Enabled")
 *             .transparentDataEncryptionName("current")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolTransparentDataEncryption current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/transparentDataEncryption/{transparentDataEncryptionName}
 * ```
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property status The status of the database transparent data encryption.
 * @property transparentDataEncryptionName The name of the transparent data encryption configuration.
 * @property workspaceName The name of the workspace.
 */
public data class SqlPoolTransparentDataEncryptionArgs(
    public val resourceGroupName: Output<String>? = null,
    public val sqlPoolName: Output<String>? = null,
    public val status: Output<Either<String, TransparentDataEncryptionStatus>>? = null,
    public val transparentDataEncryptionName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryptionArgs =
        com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryptionArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .transparentDataEncryptionName(transparentDataEncryptionName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPoolTransparentDataEncryptionArgs].
 */
@PulumiTagMarker
public class SqlPoolTransparentDataEncryptionArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var sqlPoolName: Output<String>? = null

    private var status: Output<Either<String, TransparentDataEncryptionStatus>>? = null

    private var transparentDataEncryptionName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vuimbsfqpluteqoh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("nfqvqltixwrjnngn")
    public suspend fun sqlPoolName(`value`: Output<String>) {
        this.sqlPoolName = value
    }

    /**
     * @param value The status of the database transparent data encryption.
     */
    @JvmName("rgbfoadkmbuyaaut")
    public suspend fun status(`value`: Output<Either<String, TransparentDataEncryptionStatus>>) {
        this.status = value
    }

    /**
     * @param value The name of the transparent data encryption configuration.
     */
    @JvmName("iwgqghwaenutubyn")
    public suspend fun transparentDataEncryptionName(`value`: Output<String>) {
        this.transparentDataEncryptionName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("cgutcglmytgpjbhn")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wjteugdhvnjhewfl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("hjpfgkklnisifrpv")
    public suspend fun sqlPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The status of the database transparent data encryption.
     */
    @JvmName("ubbtcrouuxugqslq")
    public suspend fun status(`value`: Either<String, TransparentDataEncryptionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the database transparent data encryption.
     */
    @JvmName("goealqaiykoojmxe")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransparentDataEncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the database transparent data encryption.
     */
    @JvmName("nxlwtrjqkjdymruf")
    public fun status(`value`: TransparentDataEncryptionStatus) {
        val toBeMapped = Either.ofRight<String, TransparentDataEncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the transparent data encryption configuration.
     */
    @JvmName("pnygebeyhdpgwkyo")
    public suspend fun transparentDataEncryptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transparentDataEncryptionName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("wdiyfopuxuxgoxym")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SqlPoolTransparentDataEncryptionArgs = SqlPoolTransparentDataEncryptionArgs(
        resourceGroupName = resourceGroupName,
        sqlPoolName = sqlPoolName,
        status = status,
        transparentDataEncryptionName = transparentDataEncryptionName,
        workspaceName = workspaceName,
    )
}
