@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlPoolVulnerabilityAssessment].
 */
@PulumiTagMarker
public class SqlPoolVulnerabilityAssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlPoolVulnerabilityAssessmentArgs = SqlPoolVulnerabilityAssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlPoolVulnerabilityAssessmentArgsBuilder.() -> Unit) {
        val builder = SqlPoolVulnerabilityAssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlPoolVulnerabilityAssessment {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlPoolVulnerabilityAssessment(builtJavaResource)
    }
}

/**
 * A Sql pool vulnerability assessment.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create a database's vulnerability assessment with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessment = new AzureNative.Synapse.SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", new()
 *     {
 *         RecurringScans = new AzureNative.Synapse.Inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
 *         {
 *             EmailSubscriptionAdmins = true,
 *             Emails = new[]
 *             {
 *                 "email1@mail.com",
 *                 "email2@mail.com",
 *             },
 *             IsEnabled = true,
 *         },
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         SqlPoolName = "testdb",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessment(ctx, "sqlPoolVulnerabilityAssessment", &synapse.SqlPoolVulnerabilityAssessmentArgs{
 * 			RecurringScans: &synapse.VulnerabilityAssessmentRecurringScansPropertiesArgs{
 * 				EmailSubscriptionAdmins: pulumi.Bool(true),
 * 				Emails: pulumi.StringArray{
 * 					pulumi.String("email1@mail.com"),
 * 					pulumi.String("email2@mail.com"),
 * 				},
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs;
 * import com.pulumi.azurenative.synapse.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessment = new SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", SqlPoolVulnerabilityAssessmentArgs.builder()
 *             .recurringScans(VulnerabilityAssessmentRecurringScansPropertiesArgs.builder()
 *                 .emailSubscriptionAdmins(true)
 *                 .emails(
 *                     "email1@mail.com",
 *                     "email2@mail.com")
 *                 .isEnabled(true)
 *                 .build())
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .sqlPoolName("testdb")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessment = new AzureNative.Synapse.SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         SqlPoolName = "testdb",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessment(ctx, "sqlPoolVulnerabilityAssessment", &synapse.SqlPoolVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessment = new SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", SqlPoolVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .sqlPoolName("testdb")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessment = new AzureNative.Synapse.SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         SqlPoolName = "testdb",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessment(ctx, "sqlPoolVulnerabilityAssessment", &synapse.SqlPoolVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessment = new SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", SqlPoolVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .sqlPoolName("testdb")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 */
public class SqlPoolVulnerabilityAssessment internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment,
) : KotlinCustomResource(javaResource, SqlPoolVulnerabilityAssessmentMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The recurring scans settings
     */
    public val recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesResponse>?
        get() = javaResource.recurringScans().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
     */
    public val storageContainerPath: Output<String>?
        get() = javaResource.storageContainerPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlPoolVulnerabilityAssessmentMapper : ResourceMapper<SqlPoolVulnerabilityAssessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment::class == javaResource::class

    override fun map(javaResource: Resource): SqlPoolVulnerabilityAssessment =
        SqlPoolVulnerabilityAssessment(
            javaResource as
                com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment,
        )
}

/**
 * @see [SqlPoolVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlPoolVulnerabilityAssessment].
 */
public suspend fun sqlPoolVulnerabilityAssessment(
    name: String,
    block: suspend SqlPoolVulnerabilityAssessmentResourceBuilder.() -> Unit,
):
    SqlPoolVulnerabilityAssessment {
    val builder = SqlPoolVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlPoolVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlPoolVulnerabilityAssessment(name: String): SqlPoolVulnerabilityAssessment {
    val builder = SqlPoolVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
