@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workload classifier operations for a data warehouse
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create a workload classifier with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadClassifier = new AzureNative.Synapse.SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", new()
 *     {
 *         Context = "test_context",
 *         EndTime = "14:00",
 *         Importance = "high",
 *         Label = "test_label",
 *         MemberName = "dbo",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         StartTime = "12:00",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadClassifier(ctx, "sqlPoolWorkloadClassifier", &synapse.SqlPoolWorkloadClassifierArgs{
 * 			Context:                pulumi.String("test_context"),
 * 			EndTime:                pulumi.String("14:00"),
 * 			Importance:             pulumi.String("high"),
 * 			Label:                  pulumi.String("test_label"),
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:            pulumi.String("sqlcrudtest-9187"),
 * 			StartTime:              pulumi.String("12:00"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 			WorkspaceName:          pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadClassifier = new SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", SqlPoolWorkloadClassifierArgs.builder()
 *             .context("test_context")
 *             .endTime("14:00")
 *             .importance("high")
 *             .label("test_label")
 *             .memberName("dbo")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .startTime("12:00")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload classifier with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadClassifier = new AzureNative.Synapse.SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", new()
 *     {
 *         MemberName = "dbo",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadClassifier(ctx, "sqlPoolWorkloadClassifier", &synapse.SqlPoolWorkloadClassifierArgs{
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:            pulumi.String("sqlcrudtest-9187"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 			WorkspaceName:          pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadClassifier = new SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", SqlPoolWorkloadClassifierArgs.builder()
 *             .memberName("dbo")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolWorkloadClassifier wlm_workloadclassifier /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/workloadGroups/{workloadGroupName}/workloadClassifiers/{workloadClassifierName}
 * ```
 * @property context The workload classifier context.
 * @property endTime The workload classifier end time for classification.
 * @property importance The workload classifier importance.
 * @property label The workload classifier label.
 * @property memberName The workload classifier member name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property startTime The workload classifier start time for classification.
 * @property workloadClassifierName The name of the workload classifier.
 * @property workloadGroupName The name of the workload group.
 * @property workspaceName The name of the workspace.
 */
public data class SqlPoolWorkloadClassifierArgs(
    public val context: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val importance: Output<String>? = null,
    public val label: Output<String>? = null,
    public val memberName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlPoolName: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val workloadClassifierName: Output<String>? = null,
    public val workloadGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs =
        com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs.builder()
            .context(context?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .importance(importance?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .memberName(memberName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .workloadClassifierName(workloadClassifierName?.applyValue({ args0 -> args0 }))
            .workloadGroupName(workloadGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPoolWorkloadClassifierArgs].
 */
@PulumiTagMarker
public class SqlPoolWorkloadClassifierArgsBuilder internal constructor() {
    private var context: Output<String>? = null

    private var endTime: Output<String>? = null

    private var importance: Output<String>? = null

    private var label: Output<String>? = null

    private var memberName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlPoolName: Output<String>? = null

    private var startTime: Output<String>? = null

    private var workloadClassifierName: Output<String>? = null

    private var workloadGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The workload classifier context.
     */
    @JvmName("urwpjlbfsileormd")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value The workload classifier end time for classification.
     */
    @JvmName("nkxrfervohttuuek")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The workload classifier importance.
     */
    @JvmName("dindrihmqwngdnlm")
    public suspend fun importance(`value`: Output<String>) {
        this.importance = value
    }

    /**
     * @param value The workload classifier label.
     */
    @JvmName("ixkoydjgxhrmgqsr")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The workload classifier member name.
     */
    @JvmName("vesdqosfrbdwiwmx")
    public suspend fun memberName(`value`: Output<String>) {
        this.memberName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rnynpmbwjvbuhxxv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("oxkvldsjlakudsqm")
    public suspend fun sqlPoolName(`value`: Output<String>) {
        this.sqlPoolName = value
    }

    /**
     * @param value The workload classifier start time for classification.
     */
    @JvmName("asstjkwsbafjyuhb")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The name of the workload classifier.
     */
    @JvmName("lhalpcxrrlfgqvqu")
    public suspend fun workloadClassifierName(`value`: Output<String>) {
        this.workloadClassifierName = value
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("xpwwblhhittjidah")
    public suspend fun workloadGroupName(`value`: Output<String>) {
        this.workloadGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ekvrfwvvgrokvptd")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The workload classifier context.
     */
    @JvmName("huwhyfnipwjheged")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value The workload classifier end time for classification.
     */
    @JvmName("oibycloncoinlfyp")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The workload classifier importance.
     */
    @JvmName("jfxaxkxtmabkhyyc")
    public suspend fun importance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importance = mapped
    }

    /**
     * @param value The workload classifier label.
     */
    @JvmName("tenuvxvlvndtedui")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The workload classifier member name.
     */
    @JvmName("rdcuulwrqwbqlrtp")
    public suspend fun memberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xexsdkxauxstwenc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("iryctrehvkwefcko")
    public suspend fun sqlPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The workload classifier start time for classification.
     */
    @JvmName("rqorxpkgcmqaejmd")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The name of the workload classifier.
     */
    @JvmName("mkfqrccyjvtceyai")
    public suspend fun workloadClassifierName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadClassifierName = mapped
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("rguxdrxyvgpysmms")
    public suspend fun workloadGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("elsdengcecorohfh")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SqlPoolWorkloadClassifierArgs = SqlPoolWorkloadClassifierArgs(
        context = context,
        endTime = endTime,
        importance = importance,
        label = label,
        memberName = memberName,
        resourceGroupName = resourceGroupName,
        sqlPoolName = sqlPoolName,
        startTime = startTime,
        workloadClassifierName = workloadClassifierName,
        workloadGroupName = workloadGroupName,
        workspaceName = workspaceName,
    )
}
