@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workload group operations for a sql pool
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create a workload group with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadGroup = new AzureNative.Synapse.SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", new()
 *     {
 *         Importance = "normal",
 *         MaxResourcePercent = 100,
 *         MaxResourcePercentPerRequest = 3,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         QueryExecutionTimeout = 0,
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         WorkloadGroupName = "smallrc",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadGroup(ctx, "sqlPoolWorkloadGroup", &synapse.SqlPoolWorkloadGroupArgs{
 * 			Importance:                   pulumi.String("normal"),
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MaxResourcePercentPerRequest: pulumi.Float64(3),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			QueryExecutionTimeout:        pulumi.Int(0),
 * 			ResourceGroupName:            pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:                  pulumi.String("sqlcrudtest-9187"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 			WorkspaceName:                pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadGroup = new SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", SqlPoolWorkloadGroupArgs.builder()
 *             .importance("normal")
 *             .maxResourcePercent(100)
 *             .maxResourcePercentPerRequest(3)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .queryExecutionTimeout(0)
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .workloadGroupName("smallrc")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload group with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadGroup = new AzureNative.Synapse.SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", new()
 *     {
 *         MaxResourcePercent = 100,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         WorkloadGroupName = "smallrc",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadGroup(ctx, "sqlPoolWorkloadGroup", &synapse.SqlPoolWorkloadGroupArgs{
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			ResourceGroupName:            pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:                  pulumi.String("sqlcrudtest-9187"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 			WorkspaceName:                pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadGroup = new SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", SqlPoolWorkloadGroupArgs.builder()
 *             .maxResourcePercent(100)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .workloadGroupName("smallrc")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolWorkloadGroup smallrc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/workloadGroups/{workloadGroupName}
 * ```
 * @property importance The workload group importance level.
 * @property maxResourcePercent The workload group cap percentage resource.
 * @property maxResourcePercentPerRequest The workload group request maximum grant percentage.
 * @property minResourcePercent The workload group minimum percentage resource.
 * @property minResourcePercentPerRequest The workload group request minimum grant percentage.
 * @property queryExecutionTimeout The workload group query execution timeout.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property workloadGroupName The name of the workload group.
 * @property workspaceName The name of the workspace.
 */
public data class SqlPoolWorkloadGroupArgs(
    public val importance: Output<String>? = null,
    public val maxResourcePercent: Output<Int>? = null,
    public val maxResourcePercentPerRequest: Output<Double>? = null,
    public val minResourcePercent: Output<Int>? = null,
    public val minResourcePercentPerRequest: Output<Double>? = null,
    public val queryExecutionTimeout: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlPoolName: Output<String>? = null,
    public val workloadGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs =
        com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs.builder()
            .importance(importance?.applyValue({ args0 -> args0 }))
            .maxResourcePercent(maxResourcePercent?.applyValue({ args0 -> args0 }))
            .maxResourcePercentPerRequest(maxResourcePercentPerRequest?.applyValue({ args0 -> args0 }))
            .minResourcePercent(minResourcePercent?.applyValue({ args0 -> args0 }))
            .minResourcePercentPerRequest(minResourcePercentPerRequest?.applyValue({ args0 -> args0 }))
            .queryExecutionTimeout(queryExecutionTimeout?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName?.applyValue({ args0 -> args0 }))
            .workloadGroupName(workloadGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPoolWorkloadGroupArgs].
 */
@PulumiTagMarker
public class SqlPoolWorkloadGroupArgsBuilder internal constructor() {
    private var importance: Output<String>? = null

    private var maxResourcePercent: Output<Int>? = null

    private var maxResourcePercentPerRequest: Output<Double>? = null

    private var minResourcePercent: Output<Int>? = null

    private var minResourcePercentPerRequest: Output<Double>? = null

    private var queryExecutionTimeout: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlPoolName: Output<String>? = null

    private var workloadGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The workload group importance level.
     */
    @JvmName("vgpfysynyemmvbww")
    public suspend fun importance(`value`: Output<String>) {
        this.importance = value
    }

    /**
     * @param value The workload group cap percentage resource.
     */
    @JvmName("hlsfllmbkdvbmncp")
    public suspend fun maxResourcePercent(`value`: Output<Int>) {
        this.maxResourcePercent = value
    }

    /**
     * @param value The workload group request maximum grant percentage.
     */
    @JvmName("ihqcvbqmnfpqsbxs")
    public suspend fun maxResourcePercentPerRequest(`value`: Output<Double>) {
        this.maxResourcePercentPerRequest = value
    }

    /**
     * @param value The workload group minimum percentage resource.
     */
    @JvmName("fsgsdaakqwpvhbwf")
    public suspend fun minResourcePercent(`value`: Output<Int>) {
        this.minResourcePercent = value
    }

    /**
     * @param value The workload group request minimum grant percentage.
     */
    @JvmName("xxeyyrcfhmdhxojy")
    public suspend fun minResourcePercentPerRequest(`value`: Output<Double>) {
        this.minResourcePercentPerRequest = value
    }

    /**
     * @param value The workload group query execution timeout.
     */
    @JvmName("rudaxdouhggbaecq")
    public suspend fun queryExecutionTimeout(`value`: Output<Int>) {
        this.queryExecutionTimeout = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("peycpqhlfijsljgb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("dpixxnooialitban")
    public suspend fun sqlPoolName(`value`: Output<String>) {
        this.sqlPoolName = value
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("tyyiqcqhepoftxeb")
    public suspend fun workloadGroupName(`value`: Output<String>) {
        this.workloadGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("lsrvoetyrhnylmyb")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The workload group importance level.
     */
    @JvmName("rgrilcvxjoynwmmf")
    public suspend fun importance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importance = mapped
    }

    /**
     * @param value The workload group cap percentage resource.
     */
    @JvmName("gayrsxnnovpxifnl")
    public suspend fun maxResourcePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxResourcePercent = mapped
    }

    /**
     * @param value The workload group request maximum grant percentage.
     */
    @JvmName("dcimlpqajvijyqpv")
    public suspend fun maxResourcePercentPerRequest(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxResourcePercentPerRequest = mapped
    }

    /**
     * @param value The workload group minimum percentage resource.
     */
    @JvmName("tiqqtsmnxbqjwplc")
    public suspend fun minResourcePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minResourcePercent = mapped
    }

    /**
     * @param value The workload group request minimum grant percentage.
     */
    @JvmName("toklnegwkjexjvre")
    public suspend fun minResourcePercentPerRequest(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minResourcePercentPerRequest = mapped
    }

    /**
     * @param value The workload group query execution timeout.
     */
    @JvmName("tdtluolujiidlgqa")
    public suspend fun queryExecutionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryExecutionTimeout = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cbwouxkyjragtwxv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("rwtgicqafuhdfbwm")
    public suspend fun sqlPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("vfqwadmbulllowwy")
    public suspend fun workloadGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("lfsmibrvgkudsukg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SqlPoolWorkloadGroupArgs = SqlPoolWorkloadGroupArgs(
        importance = importance,
        maxResourcePercent = maxResourcePercent,
        maxResourcePercentPerRequest = maxResourcePercentPerRequest,
        minResourcePercent = minResourcePercent,
        minResourcePercentPerRequest = minResourcePercentPerRequest,
        queryExecutionTimeout = queryExecutionTimeout,
        resourceGroupName = resourceGroupName,
        sqlPoolName = sqlPoolName,
        workloadGroupName = workloadGroupName,
        workspaceName = workspaceName,
    )
}
