@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceManagedSqlServerVulnerabilityAssessment].
 */
@PulumiTagMarker
public class WorkspaceManagedSqlServerVulnerabilityAssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceManagedSqlServerVulnerabilityAssessmentArgs =
        WorkspaceManagedSqlServerVulnerabilityAssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend WorkspaceManagedSqlServerVulnerabilityAssessmentArgsBuilder.() -> Unit) {
        val builder = WorkspaceManagedSqlServerVulnerabilityAssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceManagedSqlServerVulnerabilityAssessment {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )

        return WorkspaceManagedSqlServerVulnerabilityAssessment(builtJavaResource)
    }
}

/**
 * A server vulnerability assessment.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or Update a workspace managed sql server's vulnerability assessment with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagedSqlServerVulnerabilityAssessment = new AzureNative.Synapse.WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", new()
 *     {
 *         RecurringScans = new AzureNative.Synapse.Inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
 *         {
 *             EmailSubscriptionAdmins = true,
 *             Emails = new[]
 *             {
 *                 "email1@mail.com",
 *                 "email2@mail.com",
 *             },
 *             IsEnabled = true,
 *         },
 *         ResourceGroupName = "wsg-7398",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "testWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceManagedSqlServerVulnerabilityAssessment(ctx, "workspaceManagedSqlServerVulnerabilityAssessment", &synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs{
 * 			RecurringScans: &synapse.VulnerabilityAssessmentRecurringScansPropertiesArgs{
 * 				EmailSubscriptionAdmins: pulumi.Bool(true),
 * 				Emails: pulumi.StringArray{
 * 					pulumi.String("email1@mail.com"),
 * 					pulumi.String("email2@mail.com"),
 * 				},
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName:           pulumi.String("wsg-7398"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("testWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs;
 * import com.pulumi.azurenative.synapse.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagedSqlServerVulnerabilityAssessment = new WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder()
 *             .recurringScans(VulnerabilityAssessmentRecurringScansPropertiesArgs.builder()
 *                 .emailSubscriptionAdmins(true)
 *                 .emails(
 *                     "email1@mail.com",
 *                     "email2@mail.com")
 *                 .isEnabled(true)
 *                 .build())
 *             .resourceGroupName("wsg-7398")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("testWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagedSqlServerVulnerabilityAssessment = new AzureNative.Synapse.WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "wsg-7398",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "testWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceManagedSqlServerVulnerabilityAssessment(ctx, "workspaceManagedSqlServerVulnerabilityAssessment", &synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("wsg-7398"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("testWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagedSqlServerVulnerabilityAssessment = new WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("wsg-7398")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("testWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagedSqlServerVulnerabilityAssessment = new AzureNative.Synapse.WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "wsg-7398",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "testWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceManagedSqlServerVulnerabilityAssessment(ctx, "workspaceManagedSqlServerVulnerabilityAssessment", &synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("wsg-7398"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("testWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagedSqlServerVulnerabilityAssessment = new WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("wsg-7398")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("testWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:WorkspaceManagedSqlServerVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 */
public class WorkspaceManagedSqlServerVulnerabilityAssessment internal constructor(
    override val javaResource:
    com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment,
) : KotlinCustomResource(javaResource, WorkspaceManagedSqlServerVulnerabilityAssessmentMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The recurring scans settings
     */
    public val recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesResponse>?
        get() = javaResource.recurringScans().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
     */
    public val storageContainerPath: Output<String>
        get() = javaResource.storageContainerPath().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceManagedSqlServerVulnerabilityAssessmentMapper :
    ResourceMapper<WorkspaceManagedSqlServerVulnerabilityAssessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceManagedSqlServerVulnerabilityAssessment =
        WorkspaceManagedSqlServerVulnerabilityAssessment(
            javaResource as
                com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment,
        )
}

/**
 * @see [WorkspaceManagedSqlServerVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceManagedSqlServerVulnerabilityAssessment].
 */
public suspend fun workspaceManagedSqlServerVulnerabilityAssessment(
    name: String,
    block: suspend WorkspaceManagedSqlServerVulnerabilityAssessmentResourceBuilder.() -> Unit,
):
    WorkspaceManagedSqlServerVulnerabilityAssessment {
    val builder = WorkspaceManagedSqlServerVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceManagedSqlServerVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceManagedSqlServerVulnerabilityAssessment(name: String):
    WorkspaceManagedSqlServerVulnerabilityAssessment {
    val builder = WorkspaceManagedSqlServerVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
