@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder
import com.pulumi.azurenative.synapse.kotlin.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A server vulnerability assessment.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or Update a workspace managed sql server's vulnerability assessment with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagedSqlServerVulnerabilityAssessment = new AzureNative.Synapse.WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", new()
 *     {
 *         RecurringScans = new AzureNative.Synapse.Inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
 *         {
 *             EmailSubscriptionAdmins = true,
 *             Emails = new[]
 *             {
 *                 "email1@mail.com",
 *                 "email2@mail.com",
 *             },
 *             IsEnabled = true,
 *         },
 *         ResourceGroupName = "wsg-7398",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "testWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceManagedSqlServerVulnerabilityAssessment(ctx, "workspaceManagedSqlServerVulnerabilityAssessment", &synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs{
 * 			RecurringScans: &synapse.VulnerabilityAssessmentRecurringScansPropertiesArgs{
 * 				EmailSubscriptionAdmins: pulumi.Bool(true),
 * 				Emails: pulumi.StringArray{
 * 					pulumi.String("email1@mail.com"),
 * 					pulumi.String("email2@mail.com"),
 * 				},
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName:           pulumi.String("wsg-7398"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("testWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs;
 * import com.pulumi.azurenative.synapse.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagedSqlServerVulnerabilityAssessment = new WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder()
 *             .recurringScans(VulnerabilityAssessmentRecurringScansPropertiesArgs.builder()
 *                 .emailSubscriptionAdmins(true)
 *                 .emails(
 *                     "email1@mail.com",
 *                     "email2@mail.com")
 *                 .isEnabled(true)
 *                 .build())
 *             .resourceGroupName("wsg-7398")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("testWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagedSqlServerVulnerabilityAssessment = new AzureNative.Synapse.WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "wsg-7398",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "testWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceManagedSqlServerVulnerabilityAssessment(ctx, "workspaceManagedSqlServerVulnerabilityAssessment", &synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("wsg-7398"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("testWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagedSqlServerVulnerabilityAssessment = new WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("wsg-7398")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("testWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a workspace managed sql server's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagedSqlServerVulnerabilityAssessment = new AzureNative.Synapse.WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "wsg-7398",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "testWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceManagedSqlServerVulnerabilityAssessment(ctx, "workspaceManagedSqlServerVulnerabilityAssessment", &synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("wsg-7398"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("testWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagedSqlServerVulnerabilityAssessment = new WorkspaceManagedSqlServerVulnerabilityAssessment("workspaceManagedSqlServerVulnerabilityAssessment", WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("wsg-7398")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("testWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:WorkspaceManagedSqlServerVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 * @property recurringScans The recurring scans settings
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageAccountAccessKey Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
 * @property storageContainerPath A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
 * @property storageContainerSasKey A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceManagedSqlServerVulnerabilityAssessmentArgs(
    public val recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountAccessKey: Output<String>? = null,
    public val storageContainerPath: Output<String>? = null,
    public val storageContainerSasKey: Output<String>? = null,
    public val vulnerabilityAssessmentName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs =
        com.pulumi.azurenative.synapse.WorkspaceManagedSqlServerVulnerabilityAssessmentArgs.builder()
            .recurringScans(recurringScans?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountAccessKey(storageAccountAccessKey?.applyValue({ args0 -> args0 }))
            .storageContainerPath(storageContainerPath?.applyValue({ args0 -> args0 }))
            .storageContainerSasKey(storageContainerSasKey?.applyValue({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceManagedSqlServerVulnerabilityAssessmentArgs].
 */
@PulumiTagMarker
public class WorkspaceManagedSqlServerVulnerabilityAssessmentArgsBuilder internal constructor() {
    private var recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountAccessKey: Output<String>? = null

    private var storageContainerPath: Output<String>? = null

    private var storageContainerSasKey: Output<String>? = null

    private var vulnerabilityAssessmentName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The recurring scans settings
     */
    @JvmName("imfpicdfibmehukq")
    public suspend
    fun recurringScans(`value`: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>) {
        this.recurringScans = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kbqocrhvxecxetsm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     */
    @JvmName("pkisfkmjeslulkng")
    public suspend fun storageAccountAccessKey(`value`: Output<String>) {
        this.storageAccountAccessKey = value
    }

    /**
     * @param value A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
     */
    @JvmName("qhqohguoerrtbixo")
    public suspend fun storageContainerPath(`value`: Output<String>) {
        this.storageContainerPath = value
    }

    /**
     * @param value A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
     */
    @JvmName("ywtbobnncqqjxrxn")
    public suspend fun storageContainerSasKey(`value`: Output<String>) {
        this.storageContainerSasKey = value
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("tlyppfkxfvryrutl")
    public suspend fun vulnerabilityAssessmentName(`value`: Output<String>) {
        this.vulnerabilityAssessmentName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ldrwcllfjlmawwtu")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The recurring scans settings
     */
    @JvmName("uwndbbiblqiwftqj")
    public suspend fun recurringScans(`value`: VulnerabilityAssessmentRecurringScansPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurringScans = mapped
    }

    /**
     * @param argument The recurring scans settings
     */
    @JvmName("lqjdwggiuundwdpi")
    public suspend
    fun recurringScans(argument: suspend VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.recurringScans = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fnjrdxfnvtrvodsa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     */
    @JvmName("twsndymlawmjimyg")
    public suspend fun storageAccountAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountAccessKey = mapped
    }

    /**
     * @param value A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
     */
    @JvmName("cowuloxjlutvobcd")
    public suspend fun storageContainerPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerPath = mapped
    }

    /**
     * @param value A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
     */
    @JvmName("eprhjrctjxjlbkjs")
    public suspend fun storageContainerSasKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerSasKey = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("voaqjrawgbsebmuy")
    public suspend fun vulnerabilityAssessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityAssessmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ikquyxtvuaylvasc")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceManagedSqlServerVulnerabilityAssessmentArgs =
        WorkspaceManagedSqlServerVulnerabilityAssessmentArgs(
            recurringScans = recurringScans,
            resourceGroupName = resourceGroupName,
            storageAccountAccessKey = storageAccountAccessKey,
            storageContainerPath = storageContainerPath,
            storageContainerSasKey = storageContainerSasKey,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
            workspaceName = workspaceName,
        )
}
