@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceSqlAadAdmin].
 */
@PulumiTagMarker
public class WorkspaceSqlAadAdminResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceSqlAadAdminArgs = WorkspaceSqlAadAdminArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceSqlAadAdminArgsBuilder.() -> Unit) {
        val builder = WorkspaceSqlAadAdminArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceSqlAadAdmin {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.WorkspaceSqlAadAdmin(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceSqlAadAdmin(builtJavaResource)
    }
}

/**
 * Workspace active directory administrator
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * Note: SQL AAD Admin is configured automatically during workspace creation and assigned to the current user. One can't add more admins with this resource unless you manually delete the current SQL AAD Admin.
 * ## Example Usage
 * ### Create or update workspace active directory admin
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceSqlAadAdmin = new AzureNative.Synapse.WorkspaceSqlAadAdmin("workspaceSqlAadAdmin", new()
 *     {
 *         AdministratorType = "ActiveDirectory",
 *         Login = "bob@contoso.com",
 *         ResourceGroupName = "resourceGroup1",
 *         Sid = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         TenantId = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceSqlAadAdmin(ctx, "workspaceSqlAadAdmin", &synapse.WorkspaceSqlAadAdminArgs{
 * 			AdministratorType: pulumi.String("ActiveDirectory"),
 * 			Login:             pulumi.String("bob@contoso.com"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Sid:               pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			TenantId:          pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			WorkspaceName:     pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceSqlAadAdmin;
 * import com.pulumi.azurenative.synapse.WorkspaceSqlAadAdminArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceSqlAadAdmin = new WorkspaceSqlAadAdmin("workspaceSqlAadAdmin", WorkspaceSqlAadAdminArgs.builder()
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .resourceGroupName("resourceGroup1")
 *             .sid("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .tenantId("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:WorkspaceSqlAadAdmin activeDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlAdministrators/activeDirectory
 * ```
 */
public class WorkspaceSqlAadAdmin internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.WorkspaceSqlAadAdmin,
) : KotlinCustomResource(javaResource, WorkspaceSqlAadAdminMapper) {
    /**
     * Workspace active directory administrator type
     */
    public val administratorType: Output<String>?
        get() = javaResource.administratorType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Login of the workspace active directory administrator
     */
    public val login: Output<String>?
        get() = javaResource.login().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Object ID of the workspace active directory administrator
     */
    public val sid: Output<String>?
        get() = javaResource.sid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Tenant ID of the workspace active directory administrator
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceSqlAadAdminMapper : ResourceMapper<WorkspaceSqlAadAdmin> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.WorkspaceSqlAadAdmin::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceSqlAadAdmin = WorkspaceSqlAadAdmin(
        javaResource
            as com.pulumi.azurenative.synapse.WorkspaceSqlAadAdmin,
    )
}

/**
 * @see [WorkspaceSqlAadAdmin].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceSqlAadAdmin].
 */
public suspend fun workspaceSqlAadAdmin(
    name: String,
    block: suspend WorkspaceSqlAadAdminResourceBuilder.() -> Unit,
): WorkspaceSqlAadAdmin {
    val builder = WorkspaceSqlAadAdminResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceSqlAadAdmin].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceSqlAadAdmin(name: String): WorkspaceSqlAadAdmin {
    val builder = WorkspaceSqlAadAdminResourceBuilder()
    builder.name(name)
    return builder.build()
}
