@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The data format of the message. Optionally the data format can be added to each message.
 */
public enum class EventGridDataFormat(
    public val javaValue: com.pulumi.azurenative.synapse.enums.EventGridDataFormat,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.EventGridDataFormat> {
    MULTIJSON(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.MULTIJSON),
    JSON(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.JSON),
    CSV(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.CSV),
    TSV(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.TSV),
    SCSV(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.SCSV),
    SOHSV(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.SOHSV),
    PSV(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.PSV),
    TXT(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.TXT),
    RAW(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.RAW),
    SINGLEJSON(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.SINGLEJSON),
    AVRO(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.AVRO),
    TSVE(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.TSVE),
    PARQUET(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.PARQUET),
    ORC(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.ORC),
    APACHEAVRO(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.APACHEAVRO),
    W3CLOGFILE(com.pulumi.azurenative.synapse.enums.EventGridDataFormat.W3CLOGFILE),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.EventGridDataFormat = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.EventGridDataFormat):
            EventGridDataFormat = EventGridDataFormat.values().first { it.javaValue == javaType }
    }
}
