@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The storage account type used to store backups for this sql pool.
 */
public enum class StorageAccountType(
    public val javaValue: com.pulumi.azurenative.synapse.enums.StorageAccountType,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.StorageAccountType> {
    GRS(com.pulumi.azurenative.synapse.enums.StorageAccountType.GRS),
    LRS(com.pulumi.azurenative.synapse.enums.StorageAccountType.LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.StorageAccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.StorageAccountType):
            StorageAccountType = StorageAccountType.values().first { it.javaValue == javaType }
    }
}
