@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.EncryptionDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details of the encryption associated with the workspace
 * @property cmk Customer Managed Key Details
 */
public data class EncryptionDetailsArgs(
    public val cmk: Output<CustomerManagedKeyDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.EncryptionDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.EncryptionDetailsArgs =
        com.pulumi.azurenative.synapse.inputs.EncryptionDetailsArgs.builder()
            .cmk(cmk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncryptionDetailsArgs].
 */
@PulumiTagMarker
public class EncryptionDetailsArgsBuilder internal constructor() {
    private var cmk: Output<CustomerManagedKeyDetailsArgs>? = null

    /**
     * @param value Customer Managed Key Details
     */
    @JvmName("egqasegjdwdvmrdb")
    public suspend fun cmk(`value`: Output<CustomerManagedKeyDetailsArgs>) {
        this.cmk = value
    }

    /**
     * @param value Customer Managed Key Details
     */
    @JvmName("sphbvsnlereckjjr")
    public suspend fun cmk(`value`: CustomerManagedKeyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cmk = mapped
    }

    /**
     * @param argument Customer Managed Key Details
     */
    @JvmName("arkwnpckagtuimki")
    public suspend fun cmk(argument: suspend CustomerManagedKeyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomerManagedKeyDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cmk = mapped
    }

    internal fun build(): EncryptionDetailsArgs = EncryptionDetailsArgs(
        cmk = cmk,
    )
}
