@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetKustoPoolDatabasePrincipalAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database in the Kusto pool.
 * @property kustoPoolName The name of the Kusto pool.
 * @property principalAssignmentName The name of the Kusto principalAssignment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetKustoPoolDatabasePrincipalAssignmentPlainArgs(
    public val databaseName: String,
    public val kustoPoolName: String,
    public val principalAssignmentName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetKustoPoolDatabasePrincipalAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.GetKustoPoolDatabasePrincipalAssignmentPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetKustoPoolDatabasePrincipalAssignmentPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName.let({ args0 -> args0 }))
            .principalAssignmentName(principalAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKustoPoolDatabasePrincipalAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetKustoPoolDatabasePrincipalAssignmentPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var kustoPoolName: String? = null

    private var principalAssignmentName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("rxtqrplndttjxcvd")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("ecdilqivrnonbwgs")
    public suspend fun kustoPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("wlrptqbbjihojacc")
    public suspend fun principalAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalAssignmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wrbldihycubvcmpb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dtqunbwwtohsvfyh")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetKustoPoolDatabasePrincipalAssignmentPlainArgs =
        GetKustoPoolDatabasePrincipalAssignmentPlainArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            kustoPoolName = kustoPoolName ?: throw PulumiNullFieldException("kustoPoolName"),
            principalAssignmentName = principalAssignmentName ?: throw
                PulumiNullFieldException("principalAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
