@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeComputePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The compute resource properties for managed integration runtime.
 * @property dataFlowProperties Data flow properties for managed integration runtime.
 * @property location The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
 * @property maxParallelExecutionsPerNode Maximum parallel executions count per node for managed integration runtime.
 * @property nodeSize The node size requirement to managed integration runtime.
 * @property numberOfNodes The required number of nodes for managed integration runtime.
 * @property vNetProperties VNet properties for managed integration runtime.
 */
public data class IntegrationRuntimeComputePropertiesArgs(
    public val dataFlowProperties: Output<IntegrationRuntimeDataFlowPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val maxParallelExecutionsPerNode: Output<Int>? = null,
    public val nodeSize: Output<String>? = null,
    public val numberOfNodes: Output<Int>? = null,
    public val vNetProperties: Output<IntegrationRuntimeVNetPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeComputePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeComputePropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeComputePropertiesArgs.builder()
            .dataFlowProperties(
                dataFlowProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .maxParallelExecutionsPerNode(maxParallelExecutionsPerNode?.applyValue({ args0 -> args0 }))
            .nodeSize(nodeSize?.applyValue({ args0 -> args0 }))
            .numberOfNodes(numberOfNodes?.applyValue({ args0 -> args0 }))
            .vNetProperties(
                vNetProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationRuntimeComputePropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeComputePropertiesArgsBuilder internal constructor() {
    private var dataFlowProperties: Output<IntegrationRuntimeDataFlowPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var maxParallelExecutionsPerNode: Output<Int>? = null

    private var nodeSize: Output<String>? = null

    private var numberOfNodes: Output<Int>? = null

    private var vNetProperties: Output<IntegrationRuntimeVNetPropertiesArgs>? = null

    /**
     * @param value Data flow properties for managed integration runtime.
     */
    @JvmName("voqgherlkphdggfa")
    public suspend fun dataFlowProperties(`value`: Output<IntegrationRuntimeDataFlowPropertiesArgs>) {
        this.dataFlowProperties = value
    }

    /**
     * @param value The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
     */
    @JvmName("ayevrskrurqbytqh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maximum parallel executions count per node for managed integration runtime.
     */
    @JvmName("bgqcmqhrnjywsesg")
    public suspend fun maxParallelExecutionsPerNode(`value`: Output<Int>) {
        this.maxParallelExecutionsPerNode = value
    }

    /**
     * @param value The node size requirement to managed integration runtime.
     */
    @JvmName("nlnenkyxdlcgerpv")
    public suspend fun nodeSize(`value`: Output<String>) {
        this.nodeSize = value
    }

    /**
     * @param value The required number of nodes for managed integration runtime.
     */
    @JvmName("qcxdprykxkhccibe")
    public suspend fun numberOfNodes(`value`: Output<Int>) {
        this.numberOfNodes = value
    }

    /**
     * @param value VNet properties for managed integration runtime.
     */
    @JvmName("atjyiglyxjoemfdc")
    public suspend fun vNetProperties(`value`: Output<IntegrationRuntimeVNetPropertiesArgs>) {
        this.vNetProperties = value
    }

    /**
     * @param value Data flow properties for managed integration runtime.
     */
    @JvmName("kodoclidaybfpsli")
    public suspend fun dataFlowProperties(`value`: IntegrationRuntimeDataFlowPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFlowProperties = mapped
    }

    /**
     * @param argument Data flow properties for managed integration runtime.
     */
    @JvmName("opuvmptdvtucmrsw")
    public suspend
    fun dataFlowProperties(argument: suspend IntegrationRuntimeDataFlowPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeDataFlowPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataFlowProperties = mapped
    }

    /**
     * @param value The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
     */
    @JvmName("cnqnxohpysgcsqjq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maximum parallel executions count per node for managed integration runtime.
     */
    @JvmName("fhqgxxylprrlngcn")
    public suspend fun maxParallelExecutionsPerNode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxParallelExecutionsPerNode = mapped
    }

    /**
     * @param value The node size requirement to managed integration runtime.
     */
    @JvmName("waqnavetwqtxndeu")
    public suspend fun nodeSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeSize = mapped
    }

    /**
     * @param value The required number of nodes for managed integration runtime.
     */
    @JvmName("ubqkgwfxvwevqdfc")
    public suspend fun numberOfNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfNodes = mapped
    }

    /**
     * @param value VNet properties for managed integration runtime.
     */
    @JvmName("weinursgjhfvdjsk")
    public suspend fun vNetProperties(`value`: IntegrationRuntimeVNetPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vNetProperties = mapped
    }

    /**
     * @param argument VNet properties for managed integration runtime.
     */
    @JvmName("ercyphwxhxoanbgj")
    public suspend
    fun vNetProperties(argument: suspend IntegrationRuntimeVNetPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeVNetPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vNetProperties = mapped
    }

    internal fun build(): IntegrationRuntimeComputePropertiesArgs =
        IntegrationRuntimeComputePropertiesArgs(
            dataFlowProperties = dataFlowProperties,
            location = location,
            maxParallelExecutionsPerNode = maxParallelExecutionsPerNode,
            nodeSize = nodeSize,
            numberOfNodes = numberOfNodes,
            vNetProperties = vNetProperties,
        )
}
