@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataProxyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Data proxy properties for a managed dedicated integration runtime.
 * @property connectVia The self-hosted integration runtime reference.
 * @property path The path to contain the staged data in the Blob storage.
 * @property stagingLinkedService The staging linked service reference.
 */
public data class IntegrationRuntimeDataProxyPropertiesArgs(
    public val connectVia: Output<EntityReferenceArgs>? = null,
    public val path: Output<String>? = null,
    public val stagingLinkedService: Output<EntityReferenceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataProxyPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataProxyPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataProxyPropertiesArgs.builder()
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0 }))
            .stagingLinkedService(
                stagingLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationRuntimeDataProxyPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeDataProxyPropertiesArgsBuilder internal constructor() {
    private var connectVia: Output<EntityReferenceArgs>? = null

    private var path: Output<String>? = null

    private var stagingLinkedService: Output<EntityReferenceArgs>? = null

    /**
     * @param value The self-hosted integration runtime reference.
     */
    @JvmName("irmbbqhammijfcpl")
    public suspend fun connectVia(`value`: Output<EntityReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The path to contain the staged data in the Blob storage.
     */
    @JvmName("eapwfjlksgqfvniy")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The staging linked service reference.
     */
    @JvmName("ywwycqppddqpyylp")
    public suspend fun stagingLinkedService(`value`: Output<EntityReferenceArgs>) {
        this.stagingLinkedService = value
    }

    /**
     * @param value The self-hosted integration runtime reference.
     */
    @JvmName("pnghpcdrvswgbaiv")
    public suspend fun connectVia(`value`: EntityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The self-hosted integration runtime reference.
     */
    @JvmName("xlaqiloqlyrkoxrc")
    public suspend fun connectVia(argument: suspend EntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = EntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The path to contain the staged data in the Blob storage.
     */
    @JvmName("aefkcxpreifsimww")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The staging linked service reference.
     */
    @JvmName("ytkbyokxxoxswolj")
    public suspend fun stagingLinkedService(`value`: EntityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagingLinkedService = mapped
    }

    /**
     * @param argument The staging linked service reference.
     */
    @JvmName("ihvljysjitdmgqdi")
    public suspend fun stagingLinkedService(argument: suspend EntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = EntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stagingLinkedService = mapped
    }

    internal fun build(): IntegrationRuntimeDataProxyPropertiesArgs =
        IntegrationRuntimeDataProxyPropertiesArgs(
            connectVia = connectVia,
            path = path,
            stagingLinkedService = stagingLinkedService,
        )
}
