@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.LibraryRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Library requirements for a Big Data pool powered by Apache Spark
 * @property content The library requirements.
 * @property filename The filename of the library requirements file.
 */
public data class LibraryRequirementsArgs(
    public val content: Output<String>? = null,
    public val filename: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.LibraryRequirementsArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.LibraryRequirementsArgs =
        com.pulumi.azurenative.synapse.inputs.LibraryRequirementsArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .filename(filename?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LibraryRequirementsArgs].
 */
@PulumiTagMarker
public class LibraryRequirementsArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var filename: Output<String>? = null

    /**
     * @param value The library requirements.
     */
    @JvmName("sxrjqfoqrrutovoj")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The filename of the library requirements file.
     */
    @JvmName("nxcrwvrcxtwuilxc")
    public suspend fun filename(`value`: Output<String>) {
        this.filename = value
    }

    /**
     * @param value The library requirements.
     */
    @JvmName("vfarbrlurciikyfx")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The filename of the library requirements file.
     */
    @JvmName("ndamdayafemvpswg")
    public suspend fun filename(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filename = mapped
    }

    internal fun build(): LibraryRequirementsArgs = LibraryRequirementsArgs(
        content = content,
        filename = filename,
    )
}
