@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.SelfHostedIntegrationRuntimeArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Self-hosted integration runtime.
 * @property description Integration runtime description.
 * @property linkedInfo Linked integration runtime type from data factory
 * @property type The type of integration runtime.
 * Expected value is 'SelfHosted'.
 */
public data class SelfHostedIntegrationRuntimeArgs(
    public val description: Output<String>? = null,
    public val linkedInfo:
    Output<Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>>? =
        null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.SelfHostedIntegrationRuntimeArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.SelfHostedIntegrationRuntimeArgs =
        com.pulumi.azurenative.synapse.inputs.SelfHostedIntegrationRuntimeArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .linkedInfo(
                linkedInfo?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelfHostedIntegrationRuntimeArgs].
 */
@PulumiTagMarker
public class SelfHostedIntegrationRuntimeArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var linkedInfo:
        Output<Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Integration runtime description.
     */
    @JvmName("uusbdhqvemydfdfd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Linked integration runtime type from data factory
     */
    @JvmName("pkwhikwvjtbydocv")
    public suspend
    fun linkedInfo(`value`: Output<Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>>) {
        this.linkedInfo = value
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'SelfHosted'.
     */
    @JvmName("crscdkvhlswvnvif")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Integration runtime description.
     */
    @JvmName("udcghubbservbdqf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Linked integration runtime type from data factory
     */
    @JvmName("harlcbkgbdfkmeoi")
    public suspend
    fun linkedInfo(`value`: Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedInfo = mapped
    }

    /**
     * @param value Linked integration runtime type from data factory
     */
    @JvmName("iomhskcsksquyyny")
    public fun linkedInfo(`value`: LinkedIntegrationRuntimeKeyAuthorizationArgs) {
        val toBeMapped = Either.ofLeft<LinkedIntegrationRuntimeKeyAuthorizationArgs,
            LinkedIntegrationRuntimeRbacAuthorizationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedInfo = mapped
    }

    /**
     * @param value Linked integration runtime type from data factory
     */
    @JvmName("asbtobcgomjyommm")
    public fun linkedInfo(`value`: LinkedIntegrationRuntimeRbacAuthorizationArgs) {
        val toBeMapped = Either.ofRight<LinkedIntegrationRuntimeKeyAuthorizationArgs,
            LinkedIntegrationRuntimeRbacAuthorizationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedInfo = mapped
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'SelfHosted'.
     */
    @JvmName("aptbykcjbixtvswt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SelfHostedIntegrationRuntimeArgs = SelfHostedIntegrationRuntimeArgs(
        description = description,
        linkedInfo = linkedInfo,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
