@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.VirtualNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network Profile
 * @property computeSubnetId Subnet ID used for computes in workspace
 */
public data class VirtualNetworkProfileArgs(
    public val computeSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.VirtualNetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.VirtualNetworkProfileArgs =
        com.pulumi.azurenative.synapse.inputs.VirtualNetworkProfileArgs.builder()
            .computeSubnetId(computeSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkProfileArgs].
 */
@PulumiTagMarker
public class VirtualNetworkProfileArgsBuilder internal constructor() {
    private var computeSubnetId: Output<String>? = null

    /**
     * @param value Subnet ID used for computes in workspace
     */
    @JvmName("khqdrlidhowrytqk")
    public suspend fun computeSubnetId(`value`: Output<String>) {
        this.computeSubnetId = value
    }

    /**
     * @param value Subnet ID used for computes in workspace
     */
    @JvmName("fjgeahsrkhpubohm")
    public suspend fun computeSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeSubnetId = mapped
    }

    internal fun build(): VirtualNetworkProfileArgs = VirtualNetworkProfileArgs(
        computeSubnetId = computeSubnetId,
    )
}
