@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The custom setup of installing 3rd party components.
 * @property componentName The name of the 3rd party component.
 * @property licenseKey The license key to activate the component.
 * @property type The type of custom setup.
 * Expected value is 'ComponentSetup'.
 */
public data class ComponentSetupResponse(
    public val componentName: String,
    public val licenseKey: SecureStringResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.ComponentSetupResponse):
            ComponentSetupResponse = ComponentSetupResponse(
            componentName = javaType.componentName(),
            licenseKey = javaType.licenseKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
