@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Initial workspace AAD admin properties for a CSP subscription
 * @property initialWorkspaceAdminObjectId AAD object ID of initial workspace admin
 */
public data class CspWorkspaceAdminPropertiesResponse(
    public val initialWorkspaceAdminObjectId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.CspWorkspaceAdminPropertiesResponse):
            CspWorkspaceAdminPropertiesResponse = CspWorkspaceAdminPropertiesResponse(
            initialWorkspaceAdminObjectId = javaType.initialWorkspaceAdminObjectId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
