@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The role based access control (RBAC) authorization type integration runtime.
 * @property authorizationType The authorization type for integration runtime sharing.
 * Expected value is 'RBAC'.
 * @property resourceId The resource identifier of the integration runtime to be shared.
 */
public data class LinkedIntegrationRuntimeRbacAuthorizationResponse(
    public val authorizationType: String,
    public val resourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.LinkedIntegrationRuntimeRbacAuthorizationResponse):
            LinkedIntegrationRuntimeRbacAuthorizationResponse =
            LinkedIntegrationRuntimeRbacAuthorizationResponse(
                authorizationType = javaType.authorizationType(),
                resourceId = javaType.resourceId(),
            )
    }
}
