@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Ssis environment.
 * @property description Metadata description.
 * @property folderId Folder id which contains environment.
 * @property id Metadata id.
 * @property name Metadata name.
 * @property type The type of SSIS object metadata.
 * Expected value is 'Environment'.
 * @property variables Variable in environment
 */
public data class SsisEnvironmentResponse(
    public val description: String? = null,
    public val folderId: Double? = null,
    public val id: Double? = null,
    public val name: String? = null,
    public val type: String,
    public val variables: List<SsisVariableResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SsisEnvironmentResponse):
            SsisEnvironmentResponse = SsisEnvironmentResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folderId = javaType.folderId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            variables = javaType.variables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.SsisVariableResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
