@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.syntex.kotlin.inputs

import com.pulumi.azurenative.syntex.inputs.GetDocumentProcessorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property processorName The name of document processor resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDocumentProcessorPlainArgs(
    public val processorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.syntex.inputs.GetDocumentProcessorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.syntex.inputs.GetDocumentProcessorPlainArgs =
        com.pulumi.azurenative.syntex.inputs.GetDocumentProcessorPlainArgs.builder()
            .processorName(processorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDocumentProcessorPlainArgs].
 */
@PulumiTagMarker
public class GetDocumentProcessorPlainArgsBuilder internal constructor() {
    private var processorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of document processor resource.
     */
    @JvmName("mlebmwrxunjjhsfp")
    public suspend fun processorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.processorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ehsyxajtwupbuwse")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDocumentProcessorPlainArgs = GetDocumentProcessorPlainArgs(
        processorName = processorName ?: throw PulumiNullFieldException("processorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
