@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.syntex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Document processor properties
 * @property provisioningState The managed resource provisioning state.
 * @property spoTenantId The ID (GUID) of an SharePoint Online (SPO) tenant associated with this document processor resource
 * @property spoTenantUrl The URL of an SharePoint Online (SPO) tenant associated with this document processor resource
 */
public data class DocumentProcessorPropertiesResponse(
    public val provisioningState: String,
    public val spoTenantId: String,
    public val spoTenantUrl: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.syntex.outputs.DocumentProcessorPropertiesResponse):
            DocumentProcessorPropertiesResponse = DocumentProcessorPropertiesResponse(
            provisioningState = javaType.provisioningState(),
            spoTenantId = javaType.spoTenantId(),
            spoTenantUrl = javaType.spoTenantUrl(),
        )
    }
}
