@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Credential].
 */
@PulumiTagMarker
public class CredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CredentialArgs = CredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CredentialArgsBuilder.() -> Unit) {
        val builder = CredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Credential {
        val builtJavaResource = com.pulumi.azurenative.testbase.Credential(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Credential(builtJavaResource)
    }
}

/**
 * The test base credential resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### ImageDefinitionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credential = new AzureNative.TestBase.Credential("credential", new()
 *     {
 *         CredentialName = "contoso-credential",
 *         CredentialType = AzureNative.TestBase.CredentialType.IntuneAccount,
 *         DisplayName = "contoso-credential",
 *         ResourceGroupName = "contoso-rg1",
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewCredential(ctx, "credential", &testbase.CredentialArgs{
 * 			CredentialName:      pulumi.String("contoso-credential"),
 * 			CredentialType:      pulumi.String(testbase.CredentialTypeIntuneAccount),
 * 			DisplayName:         pulumi.String("contoso-credential"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.Credential;
 * import com.pulumi.azurenative.testbase.CredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credential = new Credential("credential", CredentialArgs.builder()
 *             .credentialName("contoso-credential")
 *             .credentialType("IntuneAccount")
 *             .displayName("contoso-credential")
 *             .resourceGroupName("contoso-rg1")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:Credential contoso-credential /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/credentials/{credentialName}
 * ```
 */
public class Credential internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.Credential,
) : KotlinCustomResource(javaResource, CredentialMapper) {
    /**
     * Credential type.
     */
    public val credentialType: Output<String>
        get() = javaResource.credentialType().applyValue({ args0 -> args0 })

    /**
     * Credential display name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CredentialMapper : ResourceMapper<Credential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.Credential::class == javaResource::class

    override fun map(javaResource: Resource): Credential = Credential(
        javaResource as
            com.pulumi.azurenative.testbase.Credential,
    )
}

/**
 * @see [Credential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Credential].
 */
public suspend fun credential(name: String, block: suspend CredentialResourceBuilder.() -> Unit):
    Credential {
    val builder = CredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Credential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun credential(name: String): Credential {
    val builder = CredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
