@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.DraftPackageIntuneAppMetadataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.FirstPartyAppDefinitionResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.GalleryAppDefinitionResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.HighlightedFileResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.InplaceUpgradeOSInfoResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.IntuneEnrollmentMetadataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.TabStateResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.TargetOSInfoResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.TestResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.testbase.kotlin.outputs.DraftPackageIntuneAppMetadataResponse.Companion.toKotlin as draftPackageIntuneAppMetadataResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.FirstPartyAppDefinitionResponse.Companion.toKotlin as firstPartyAppDefinitionResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GalleryAppDefinitionResponse.Companion.toKotlin as galleryAppDefinitionResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.HighlightedFileResponse.Companion.toKotlin as highlightedFileResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.InplaceUpgradeOSInfoResponse.Companion.toKotlin as inplaceUpgradeOSInfoResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.IntuneEnrollmentMetadataResponse.Companion.toKotlin as intuneEnrollmentMetadataResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.TabStateResponse.Companion.toKotlin as tabStateResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.TargetOSInfoResponse.Companion.toKotlin as targetOSInfoResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.TestResponse.Companion.toKotlin as testResponseToKotlin

/**
 * Builder for [DraftPackage].
 */
@PulumiTagMarker
public class DraftPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DraftPackageArgs = DraftPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DraftPackageArgsBuilder.() -> Unit) {
        val builder = DraftPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DraftPackage {
        val builtJavaResource = com.pulumi.azurenative.testbase.DraftPackage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DraftPackage(builtJavaResource)
    }
}

/**
 * The Test Base Draft Package resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### DraftPackageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var draftPackage = new AzureNative.TestBase.DraftPackage("draftPackage", new()
 *     {
 *         AppFileName = "TestBaseM365DigitalClock.msi",
 *         ApplicationName = "contoso-package",
 *         DraftPackageName = "61d99543-14ff-47ae-bf03-8a8b8445502e",
 *         ResourceGroupName = "contoso-rg1",
 *         SourceType = AzureNative.TestBase.DraftPackageSourceType.Native,
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *         UseSample = false,
 *         Version = "1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewDraftPackage(ctx, "draftPackage", &testbase.DraftPackageArgs{
 * 			AppFileName:         pulumi.String("TestBaseM365DigitalClock.msi"),
 * 			ApplicationName:     pulumi.String("contoso-package"),
 * 			DraftPackageName:    pulumi.String("61d99543-14ff-47ae-bf03-8a8b8445502e"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			SourceType:          pulumi.String(testbase.DraftPackageSourceTypeNative),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 			UseSample:           pulumi.Bool(false),
 * 			Version:             pulumi.String("1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.DraftPackage;
 * import com.pulumi.azurenative.testbase.DraftPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var draftPackage = new DraftPackage("draftPackage", DraftPackageArgs.builder()
 *             .appFileName("TestBaseM365DigitalClock.msi")
 *             .applicationName("contoso-package")
 *             .draftPackageName("61d99543-14ff-47ae-bf03-8a8b8445502e")
 *             .resourceGroupName("contoso-rg1")
 *             .sourceType("Native")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .useSample(false)
 *             .version("1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:DraftPackage 61d99543-14ff-47ae-bf03-8a8b8445502e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/draftPackages/{draftPackageName}
 * ```
 */
public class DraftPackage internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.DraftPackage,
) : KotlinCustomResource(javaResource, DraftPackageMapper) {
    /**
     * The name of the app file.
     */
    public val appFileName: Output<String>?
        get() = javaResource.appFileName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Application name
     */
    public val applicationName: Output<String>?
        get() = javaResource.applicationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Comments added by user.
     */
    public val comments: Output<String>?
        get() = javaResource.comments().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The relative path of the folder hosting package files.
     */
    public val draftPackagePath: Output<String>
        get() = javaResource.draftPackagePath().applyValue({ args0 -> args0 })

    /**
     * Specifies whether this draft package is used to edit a package.
     */
    public val editPackage: Output<Boolean>?
        get() = javaResource.editPackage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The executable launch command for script auto-fill. Will be used to run the application.
     */
    public val executableLaunchCommand: Output<String>?
        get() = javaResource.executableLaunchCommand().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of first party applications to test along with user application.
     */
    public val firstPartyApps: Output<List<FirstPartyAppDefinitionResponse>>?
        get() = javaResource.firstPartyApps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        firstPartyAppDefinitionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The flighting ring for feature update.
     */
    public val flightingRing: Output<String>?
        get() = javaResource.flightingRing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of gallery apps to test along with user application.
     */
    public val galleryApps: Output<List<GalleryAppDefinitionResponse>>?
        get() = javaResource.galleryApps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> galleryAppDefinitionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The highlight files in the package.
     */
    public val highlightedFiles: Output<List<HighlightedFileResponse>>?
        get() = javaResource.highlightedFiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        highlightedFileResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Specifies the baseline os and target os for inplace upgrade.
     */
    public val inplaceUpgradeOSPair: Output<InplaceUpgradeOSInfoResponse>?
        get() = javaResource.inplaceUpgradeOSPair().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> inplaceUpgradeOSInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The metadata of Intune enrollment.
     */
    public val intuneEnrollmentMetadata: Output<IntuneEnrollmentMetadataResponse>?
        get() = javaResource.intuneEnrollmentMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> intuneEnrollmentMetadataResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Metadata used to generate draft package folder and scripts.
     */
    public val intuneMetadata: Output<DraftPackageIntuneAppMetadataResponse>?
        get() = javaResource.intuneMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> draftPackageIntuneAppMetadataResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The UTC timestamp when the package was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the package id from which the draft package copied.
     */
    public val packageId: Output<String>?
        get() = javaResource.packageId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Tags of the package to be created.
     */
    public val packageTags: Output<Map<String, String>>?
        get() = javaResource.packageTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The process name for script auto-fill. Will be used to identify the application process.
     */
    public val processName: Output<String>?
        get() = javaResource.processName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The source type.
     */
    public val sourceType: Output<String>?
        get() = javaResource.sourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tab state.
     */
    public val tabState: Output<TabStateResponse>?
        get() = javaResource.tabState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tabStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the target OSs of specific OS Update types.
     */
    public val targetOSList: Output<List<TargetOSInfoResponse>>?
        get() = javaResource.targetOSList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> targetOSInfoResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * OOB, functional or flow driven. Mapped to the data in 'tests' property.
     */
    public val testTypes: Output<List<String>>?
        get() = javaResource.testTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The detailed test information.
     */
    public val tests: Output<List<TestResponse>>?
        get() = javaResource.tests().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> testResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Indicates whether user choose to enable script auto-fill.
     */
    public val useAutofill: Output<Boolean>?
        get() = javaResource.useAutofill().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether a sample package should be used instead of the one uploaded by the user.
     */
    public val useSample: Output<Boolean>?
        get() = javaResource.useSample().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Application version
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The relative path for a temporarily folder for package creation work.
     */
    public val workingPath: Output<String>
        get() = javaResource.workingPath().applyValue({ args0 -> args0 })
}

public object DraftPackageMapper : ResourceMapper<DraftPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.DraftPackage::class == javaResource::class

    override fun map(javaResource: Resource): DraftPackage = DraftPackage(
        javaResource as
            com.pulumi.azurenative.testbase.DraftPackage,
    )
}

/**
 * @see [DraftPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DraftPackage].
 */
public suspend fun draftPackage(
    name: String,
    block: suspend DraftPackageResourceBuilder.() -> Unit,
): DraftPackage {
    val builder = DraftPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DraftPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun draftPackage(name: String): DraftPackage {
    val builder = DraftPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
