@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FavoriteProcess].
 */
@PulumiTagMarker
public class FavoriteProcessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FavoriteProcessArgs = FavoriteProcessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FavoriteProcessArgsBuilder.() -> Unit) {
        val builder = FavoriteProcessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FavoriteProcess {
        val builtJavaResource = com.pulumi.azurenative.testbase.FavoriteProcess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FavoriteProcess(builtJavaResource)
    }
}

/**
 * A favorite process identifier.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Example Usage
 * ### FavoriteProcessCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var favoriteProcess = new AzureNative.TestBase.FavoriteProcess("favoriteProcess", new()
 *     {
 *         ActualProcessName = "testApp&.exe",
 *         FavoriteProcessResourceName = "testAppProcess",
 *         PackageName = "contoso-package2",
 *         ResourceGroupName = "contoso-rg1",
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewFavoriteProcess(ctx, "favoriteProcess", &testbase.FavoriteProcessArgs{
 * 			ActualProcessName:           pulumi.String("testApp&.exe"),
 * 			FavoriteProcessResourceName: pulumi.String("testAppProcess"),
 * 			PackageName:                 pulumi.String("contoso-package2"),
 * 			ResourceGroupName:           pulumi.String("contoso-rg1"),
 * 			TestBaseAccountName:         pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.FavoriteProcess;
 * import com.pulumi.azurenative.testbase.FavoriteProcessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var favoriteProcess = new FavoriteProcess("favoriteProcess", FavoriteProcessArgs.builder()
 *             .actualProcessName("testApp&.exe")
 *             .favoriteProcessResourceName("testAppProcess")
 *             .packageName("contoso-package2")
 *             .resourceGroupName("contoso-rg1")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:FavoriteProcess testAppProcess /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses/{favoriteProcessResourceName}
 * ```
 */
public class FavoriteProcess internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.FavoriteProcess,
) : KotlinCustomResource(javaResource, FavoriteProcessMapper) {
    /**
     * The actual name of the favorite process. It will be equal to resource name except for the scenario that the process name contains characters that are not allowed in the resource name.
     */
    public val actualProcessName: Output<String>
        get() = javaResource.actualProcessName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FavoriteProcessMapper : ResourceMapper<FavoriteProcess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.FavoriteProcess::class == javaResource::class

    override fun map(javaResource: Resource): FavoriteProcess = FavoriteProcess(
        javaResource as
            com.pulumi.azurenative.testbase.FavoriteProcess,
    )
}

/**
 * @see [FavoriteProcess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FavoriteProcess].
 */
public suspend fun favoriteProcess(
    name: String,
    block: suspend FavoriteProcessResourceBuilder.() -> Unit,
): FavoriteProcess {
    val builder = FavoriteProcessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FavoriteProcess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun favoriteProcess(name: String): FavoriteProcess {
    val builder = FavoriteProcessResourceBuilder()
    builder.name(name)
    return builder.build()
}
