@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.TestBaseAccountArgs.builder
import com.pulumi.azurenative.testbase.kotlin.inputs.TestBaseAccountSKUArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TestBaseAccountSKUArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Test Base Account resource.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Example Usage
 * ### TestBaseAccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testBaseAccount = new AzureNative.TestBase.TestBaseAccount("testBaseAccount", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "contoso-rg1",
 *         Sku = new AzureNative.TestBase.Inputs.TestBaseAccountSKUArgs
 *         {
 *             Name = "S0",
 *             Tier = AzureNative.TestBase.Tier.Standard,
 *         },
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewTestBaseAccount(ctx, "testBaseAccount", &testbase.TestBaseAccountArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("contoso-rg1"),
 * 			Sku: &testbase.TestBaseAccountSKUArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String(testbase.TierStandard),
 * 			},
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.TestBaseAccount;
 * import com.pulumi.azurenative.testbase.TestBaseAccountArgs;
 * import com.pulumi.azurenative.testbase.inputs.TestBaseAccountSKUArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBaseAccount = new TestBaseAccount("testBaseAccount", TestBaseAccountArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("contoso-rg1")
 *             .sku(TestBaseAccountSKUArgs.builder()
 *                 .name("S0")
 *                 .tier("Standard")
 *                 .build())
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:TestBaseAccount contoso-testBaseAccount1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property restore The flag indicating if we would like to restore the Test Base Accounts which were soft deleted before.
 * @property sku The SKU of the Test Base Account.
 * @property tags The tags of the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class TestBaseAccountArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restore: Output<Boolean>? = null,
    public val sku: Output<TestBaseAccountSKUArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val testBaseAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.TestBaseAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.TestBaseAccountArgs =
        com.pulumi.azurenative.testbase.TestBaseAccountArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restore(restore?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TestBaseAccountArgs].
 */
@PulumiTagMarker
public class TestBaseAccountArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var restore: Output<Boolean>? = null

    private var sku: Output<TestBaseAccountSKUArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var testBaseAccountName: Output<String>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nvfquhdfoualjdoo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("baygtsjsgoectnvd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The flag indicating if we would like to restore the Test Base Accounts which were soft deleted before.
     */
    @JvmName("oqgqtbjciwuocdat")
    public suspend fun restore(`value`: Output<Boolean>) {
        this.restore = value
    }

    /**
     * @param value The SKU of the Test Base Account.
     */
    @JvmName("yawemrfbukvxvqxc")
    public suspend fun sku(`value`: Output<TestBaseAccountSKUArgs>) {
        this.sku = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("wefaasmohyjntkig")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("nwndalrylbgpinmr")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wsvfvriyulbiioko")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("uvfverpsrfcxgafw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The flag indicating if we would like to restore the Test Base Accounts which were soft deleted before.
     */
    @JvmName("aauskbfvounbfwhy")
    public suspend fun restore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restore = mapped
    }

    /**
     * @param value The SKU of the Test Base Account.
     */
    @JvmName("imslipyvseifdmqx")
    public suspend fun sku(`value`: TestBaseAccountSKUArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the Test Base Account.
     */
    @JvmName("wutxsanjorhftgtv")
    public suspend fun sku(argument: suspend TestBaseAccountSKUArgsBuilder.() -> Unit) {
        val toBeMapped = TestBaseAccountSKUArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ssbmwkmxrgajdbtx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("uqrvpuptusutgsun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("fryqsvbinlgeyekg")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    internal fun build(): TestBaseAccountArgs = TestBaseAccountArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        restore = restore,
        sku = sku,
        tags = tags,
        testBaseAccountName = testBaseAccountName,
    )
}
