@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the test.
 */
public enum class TestType(
    public val javaValue: com.pulumi.azurenative.testbase.enums.TestType,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.TestType> {
    OutOfBoxTest(com.pulumi.azurenative.testbase.enums.TestType.OutOfBoxTest),
    FunctionalTest(com.pulumi.azurenative.testbase.enums.TestType.FunctionalTest),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.TestType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.TestType): TestType =
            TestType.values().first { it.javaValue == javaType }
    }
}
