@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.CommandArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.Action
import com.pulumi.azurenative.testbase.kotlin.enums.ContentType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The command used in the test
 * @property action The action of the command.
 * @property alwaysRun Specifies whether to run the command even if a previous command is failed.
 * @property applyUpdateBefore Specifies whether to apply update before the command.
 * @property content The content of the command. The content depends on source type.
 * @property contentType The type of command content.
 * @property enrollIntuneBefore Specifies whether to enroll Intune before the command.
 * @property install1PAppBefore Specifies whether to install first party applications before running the command.
 * @property maxRunTime Specifies the max run time of the command.
 * @property name The name of the command.
 * @property postUpgrade Specifies whether the command is assigned to be executed after in-place upgrade.
 * @property preUpgrade Specifies whether the command is assigned to be executed before in-place upgrade.
 * @property restartAfter Specifies whether to restart the VM after the command executed.
 * @property runAsInteractive Specifies whether to run the command in interactive mode.
 * @property runElevated Specifies whether to run the command as administrator.
 */
public data class CommandArgs(
    public val action: Output<Either<String, Action>>,
    public val alwaysRun: Output<Boolean>? = null,
    public val applyUpdateBefore: Output<Boolean>? = null,
    public val content: Output<String>,
    public val contentType: Output<Either<String, ContentType>>,
    public val enrollIntuneBefore: Output<Boolean>? = null,
    public val install1PAppBefore: Output<Boolean>? = null,
    public val maxRunTime: Output<Int>? = null,
    public val name: Output<String>,
    public val postUpgrade: Output<Boolean>? = null,
    public val preUpgrade: Output<Boolean>? = null,
    public val restartAfter: Output<Boolean>? = null,
    public val runAsInteractive: Output<Boolean>? = null,
    public val runElevated: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.CommandArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.CommandArgs =
        com.pulumi.azurenative.testbase.inputs.CommandArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .alwaysRun(alwaysRun?.applyValue({ args0 -> args0 }))
            .applyUpdateBefore(applyUpdateBefore?.applyValue({ args0 -> args0 }))
            .content(content.applyValue({ args0 -> args0 }))
            .contentType(
                contentType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enrollIntuneBefore(enrollIntuneBefore?.applyValue({ args0 -> args0 }))
            .install1PAppBefore(install1PAppBefore?.applyValue({ args0 -> args0 }))
            .maxRunTime(maxRunTime?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .postUpgrade(postUpgrade?.applyValue({ args0 -> args0 }))
            .preUpgrade(preUpgrade?.applyValue({ args0 -> args0 }))
            .restartAfter(restartAfter?.applyValue({ args0 -> args0 }))
            .runAsInteractive(runAsInteractive?.applyValue({ args0 -> args0 }))
            .runElevated(runElevated?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommandArgs].
 */
@PulumiTagMarker
public class CommandArgsBuilder internal constructor() {
    private var action: Output<Either<String, Action>>? = null

    private var alwaysRun: Output<Boolean>? = null

    private var applyUpdateBefore: Output<Boolean>? = null

    private var content: Output<String>? = null

    private var contentType: Output<Either<String, ContentType>>? = null

    private var enrollIntuneBefore: Output<Boolean>? = null

    private var install1PAppBefore: Output<Boolean>? = null

    private var maxRunTime: Output<Int>? = null

    private var name: Output<String>? = null

    private var postUpgrade: Output<Boolean>? = null

    private var preUpgrade: Output<Boolean>? = null

    private var restartAfter: Output<Boolean>? = null

    private var runAsInteractive: Output<Boolean>? = null

    private var runElevated: Output<Boolean>? = null

    /**
     * @param value The action of the command.
     */
    @JvmName("vlcfxkcfqbkxggvi")
    public suspend fun action(`value`: Output<Either<String, Action>>) {
        this.action = value
    }

    /**
     * @param value Specifies whether to run the command even if a previous command is failed.
     */
    @JvmName("lgcjvurrehwqiqyi")
    public suspend fun alwaysRun(`value`: Output<Boolean>) {
        this.alwaysRun = value
    }

    /**
     * @param value Specifies whether to apply update before the command.
     */
    @JvmName("vpcygxmtqyntaruv")
    public suspend fun applyUpdateBefore(`value`: Output<Boolean>) {
        this.applyUpdateBefore = value
    }

    /**
     * @param value The content of the command. The content depends on source type.
     */
    @JvmName("cligmrodfagnevrx")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("esfpbonsrttoxfle")
    public suspend fun contentType(`value`: Output<Either<String, ContentType>>) {
        this.contentType = value
    }

    /**
     * @param value Specifies whether to enroll Intune before the command.
     */
    @JvmName("lmemnnqkubfweqdb")
    public suspend fun enrollIntuneBefore(`value`: Output<Boolean>) {
        this.enrollIntuneBefore = value
    }

    /**
     * @param value Specifies whether to install first party applications before running the command.
     */
    @JvmName("hamgccpujhedstta")
    public suspend fun install1PAppBefore(`value`: Output<Boolean>) {
        this.install1PAppBefore = value
    }

    /**
     * @param value Specifies the max run time of the command.
     */
    @JvmName("fggnsdgtnmmqquxy")
    public suspend fun maxRunTime(`value`: Output<Int>) {
        this.maxRunTime = value
    }

    /**
     * @param value The name of the command.
     */
    @JvmName("ietsobredtxkottx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether the command is assigned to be executed after in-place upgrade.
     */
    @JvmName("furcqiyibqtpmpkk")
    public suspend fun postUpgrade(`value`: Output<Boolean>) {
        this.postUpgrade = value
    }

    /**
     * @param value Specifies whether the command is assigned to be executed before in-place upgrade.
     */
    @JvmName("olikjypkmqgqjcou")
    public suspend fun preUpgrade(`value`: Output<Boolean>) {
        this.preUpgrade = value
    }

    /**
     * @param value Specifies whether to restart the VM after the command executed.
     */
    @JvmName("cahsmwjttkudysid")
    public suspend fun restartAfter(`value`: Output<Boolean>) {
        this.restartAfter = value
    }

    /**
     * @param value Specifies whether to run the command in interactive mode.
     */
    @JvmName("idtigcwwtvmsqawo")
    public suspend fun runAsInteractive(`value`: Output<Boolean>) {
        this.runAsInteractive = value
    }

    /**
     * @param value Specifies whether to run the command as administrator.
     */
    @JvmName("gnuovrdfeifmdjrs")
    public suspend fun runElevated(`value`: Output<Boolean>) {
        this.runElevated = value
    }

    /**
     * @param value The action of the command.
     */
    @JvmName("sphvrwdmkybekily")
    public suspend fun action(`value`: Either<String, Action>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The action of the command.
     */
    @JvmName("vtnbnandytwjjbpw")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The action of the command.
     */
    @JvmName("wmymvxhgcrqeleay")
    public fun action(`value`: Action) {
        val toBeMapped = Either.ofRight<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Specifies whether to run the command even if a previous command is failed.
     */
    @JvmName("apurnmgnqxdlnlki")
    public suspend fun alwaysRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysRun = mapped
    }

    /**
     * @param value Specifies whether to apply update before the command.
     */
    @JvmName("rdmlldccpqrdkvmh")
    public suspend fun applyUpdateBefore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyUpdateBefore = mapped
    }

    /**
     * @param value The content of the command. The content depends on source type.
     */
    @JvmName("nihswokhfomjceqv")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("yfkxqfcfxkpayryh")
    public suspend fun contentType(`value`: Either<String, ContentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("xsbgfjsxwsrihkcm")
    public fun contentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("dplavrvxmrgofeky")
    public fun contentType(`value`: ContentType) {
        val toBeMapped = Either.ofRight<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Specifies whether to enroll Intune before the command.
     */
    @JvmName("lyjralleeveuhule")
    public suspend fun enrollIntuneBefore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enrollIntuneBefore = mapped
    }

    /**
     * @param value Specifies whether to install first party applications before running the command.
     */
    @JvmName("vcshbitifusnnirr")
    public suspend fun install1PAppBefore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.install1PAppBefore = mapped
    }

    /**
     * @param value Specifies the max run time of the command.
     */
    @JvmName("uhljpalfnwjkjifd")
    public suspend fun maxRunTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRunTime = mapped
    }

    /**
     * @param value The name of the command.
     */
    @JvmName("uueogdrwgqyfsolk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether the command is assigned to be executed after in-place upgrade.
     */
    @JvmName("wukayovpdemtleld")
    public suspend fun postUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postUpgrade = mapped
    }

    /**
     * @param value Specifies whether the command is assigned to be executed before in-place upgrade.
     */
    @JvmName("uhjeloikfstiwyms")
    public suspend fun preUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preUpgrade = mapped
    }

    /**
     * @param value Specifies whether to restart the VM after the command executed.
     */
    @JvmName("hlodssooqnbfrrsa")
    public suspend fun restartAfter(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartAfter = mapped
    }

    /**
     * @param value Specifies whether to run the command in interactive mode.
     */
    @JvmName("mxctcephlrilifrf")
    public suspend fun runAsInteractive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsInteractive = mapped
    }

    /**
     * @param value Specifies whether to run the command as administrator.
     */
    @JvmName("mtvbnswuoaoesjvl")
    public suspend fun runElevated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runElevated = mapped
    }

    internal fun build(): CommandArgs = CommandArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        alwaysRun = alwaysRun,
        applyUpdateBefore = applyUpdateBefore,
        content = content ?: throw PulumiNullFieldException("content"),
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        enrollIntuneBefore = enrollIntuneBefore,
        install1PAppBefore = install1PAppBefore,
        maxRunTime = maxRunTime,
        name = name ?: throw PulumiNullFieldException("name"),
        postUpgrade = postUpgrade,
        preUpgrade = preUpgrade,
        restartAfter = restartAfter,
        runAsInteractive = runAsInteractive,
        runElevated = runElevated,
    )
}
