@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataItemArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.IntuneExtractStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Metadata of a single Intune App.
 * @property appId Intune app id.
 * @property appName Intune app name.
 * @property createDate Creation date of the app.
 * @property dependencyIds Ids of dependency apps.
 * @property dependentAppCount Count of dependency apps.
 * @property description Description of the app.
 * @property expectedExitCodes Expected exit codes returned from Intune App.
 * @property installCommand Install command.
 * @property lastProcessed last processed time tickets.
 * @property minimumSupportedOS Minimum supported OS. The OS version must be greater than this version to run this app.
 * @property owner Owner of the app.
 * @property publisher Publisher of the app.
 * @property setupFile Setup file path.
 * @property status Extract status.
 * @property uninstallCommand Uninstall command.
 * @property version Intune app version.
 */
public data class DraftPackageIntuneAppMetadataItemArgs(
    public val appId: Output<String>? = null,
    public val appName: Output<String>? = null,
    public val createDate: Output<String>? = null,
    public val dependencyIds: Output<List<String>>? = null,
    public val dependentAppCount: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val expectedExitCodes: Output<List<String>>? = null,
    public val installCommand: Output<String>? = null,
    public val lastProcessed: Output<Double>? = null,
    public val minimumSupportedOS: Output<String>? = null,
    public val owner: Output<String>? = null,
    public val publisher: Output<String>? = null,
    public val setupFile: Output<String>? = null,
    public val status: Output<Either<String, IntuneExtractStatus>>? = null,
    public val uninstallCommand: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataItemArgs> {
    override fun toJava():
        com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataItemArgs =
        com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataItemArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .appName(appName?.applyValue({ args0 -> args0 }))
            .createDate(createDate?.applyValue({ args0 -> args0 }))
            .dependencyIds(dependencyIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dependentAppCount(dependentAppCount?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .expectedExitCodes(expectedExitCodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .installCommand(installCommand?.applyValue({ args0 -> args0 }))
            .lastProcessed(lastProcessed?.applyValue({ args0 -> args0 }))
            .minimumSupportedOS(minimumSupportedOS?.applyValue({ args0 -> args0 }))
            .owner(owner?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .setupFile(setupFile?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .uninstallCommand(uninstallCommand?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DraftPackageIntuneAppMetadataItemArgs].
 */
@PulumiTagMarker
public class DraftPackageIntuneAppMetadataItemArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appName: Output<String>? = null

    private var createDate: Output<String>? = null

    private var dependencyIds: Output<List<String>>? = null

    private var dependentAppCount: Output<Int>? = null

    private var description: Output<String>? = null

    private var expectedExitCodes: Output<List<String>>? = null

    private var installCommand: Output<String>? = null

    private var lastProcessed: Output<Double>? = null

    private var minimumSupportedOS: Output<String>? = null

    private var owner: Output<String>? = null

    private var publisher: Output<String>? = null

    private var setupFile: Output<String>? = null

    private var status: Output<Either<String, IntuneExtractStatus>>? = null

    private var uninstallCommand: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Intune app id.
     */
    @JvmName("uatqnekhshtnoapd")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Intune app name.
     */
    @JvmName("fxokfsxykxhewwqk")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Creation date of the app.
     */
    @JvmName("unaaqnxjnuohtgxu")
    public suspend fun createDate(`value`: Output<String>) {
        this.createDate = value
    }

    /**
     * @param value Ids of dependency apps.
     */
    @JvmName("lrhabqabdovfyvrm")
    public suspend fun dependencyIds(`value`: Output<List<String>>) {
        this.dependencyIds = value
    }

    @JvmName("whgutcwjmydcboon")
    public suspend fun dependencyIds(vararg values: Output<String>) {
        this.dependencyIds = Output.all(values.asList())
    }

    /**
     * @param values Ids of dependency apps.
     */
    @JvmName("mpiafoelucjtffff")
    public suspend fun dependencyIds(values: List<Output<String>>) {
        this.dependencyIds = Output.all(values)
    }

    /**
     * @param value Count of dependency apps.
     */
    @JvmName("gvpqkvvvhinqlrfg")
    public suspend fun dependentAppCount(`value`: Output<Int>) {
        this.dependentAppCount = value
    }

    /**
     * @param value Description of the app.
     */
    @JvmName("guugbqauftqsqopl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Expected exit codes returned from Intune App.
     */
    @JvmName("vrjnnlxylllsvjew")
    public suspend fun expectedExitCodes(`value`: Output<List<String>>) {
        this.expectedExitCodes = value
    }

    @JvmName("xeplpevltklqtdsr")
    public suspend fun expectedExitCodes(vararg values: Output<String>) {
        this.expectedExitCodes = Output.all(values.asList())
    }

    /**
     * @param values Expected exit codes returned from Intune App.
     */
    @JvmName("xfsvwhjpwdglisqj")
    public suspend fun expectedExitCodes(values: List<Output<String>>) {
        this.expectedExitCodes = Output.all(values)
    }

    /**
     * @param value Install command.
     */
    @JvmName("pofsfvswdrbbmqed")
    public suspend fun installCommand(`value`: Output<String>) {
        this.installCommand = value
    }

    /**
     * @param value last processed time tickets.
     */
    @JvmName("vhvcvofjklcriilg")
    public suspend fun lastProcessed(`value`: Output<Double>) {
        this.lastProcessed = value
    }

    /**
     * @param value Minimum supported OS. The OS version must be greater than this version to run this app.
     */
    @JvmName("mlheclfpdaovgouu")
    public suspend fun minimumSupportedOS(`value`: Output<String>) {
        this.minimumSupportedOS = value
    }

    /**
     * @param value Owner of the app.
     */
    @JvmName("tbmaubeqpuicuqal")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value Publisher of the app.
     */
    @JvmName("jwabahpewdixsjfj")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Setup file path.
     */
    @JvmName("abxcwlspttuxwqfu")
    public suspend fun setupFile(`value`: Output<String>) {
        this.setupFile = value
    }

    /**
     * @param value Extract status.
     */
    @JvmName("stibharkoakeftcb")
    public suspend fun status(`value`: Output<Either<String, IntuneExtractStatus>>) {
        this.status = value
    }

    /**
     * @param value Uninstall command.
     */
    @JvmName("qrgelhutjkghaney")
    public suspend fun uninstallCommand(`value`: Output<String>) {
        this.uninstallCommand = value
    }

    /**
     * @param value Intune app version.
     */
    @JvmName("uieflcixndnuqraq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Intune app id.
     */
    @JvmName("vmwbunhuilxwfjqc")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Intune app name.
     */
    @JvmName("xijoojrbkyunmhlm")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Creation date of the app.
     */
    @JvmName("fbuspcrlnqtdnica")
    public suspend fun createDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createDate = mapped
    }

    /**
     * @param value Ids of dependency apps.
     */
    @JvmName("yrmmgyeflmuquwcp")
    public suspend fun dependencyIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencyIds = mapped
    }

    /**
     * @param values Ids of dependency apps.
     */
    @JvmName("jqjaaeoufcctails")
    public suspend fun dependencyIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependencyIds = mapped
    }

    /**
     * @param value Count of dependency apps.
     */
    @JvmName("wkrmfysuncllwybu")
    public suspend fun dependentAppCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependentAppCount = mapped
    }

    /**
     * @param value Description of the app.
     */
    @JvmName("sjyljlregqskuert")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Expected exit codes returned from Intune App.
     */
    @JvmName("nrqagukaqnmgiudf")
    public suspend fun expectedExitCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedExitCodes = mapped
    }

    /**
     * @param values Expected exit codes returned from Intune App.
     */
    @JvmName("rmiwfggjomwvtkbm")
    public suspend fun expectedExitCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expectedExitCodes = mapped
    }

    /**
     * @param value Install command.
     */
    @JvmName("qdnwxgakkjcibkkt")
    public suspend fun installCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installCommand = mapped
    }

    /**
     * @param value last processed time tickets.
     */
    @JvmName("kdajgaquclmtovya")
    public suspend fun lastProcessed(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastProcessed = mapped
    }

    /**
     * @param value Minimum supported OS. The OS version must be greater than this version to run this app.
     */
    @JvmName("bxxlsskngjhdsiue")
    public suspend fun minimumSupportedOS(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumSupportedOS = mapped
    }

    /**
     * @param value Owner of the app.
     */
    @JvmName("jhtweejkxwhqwnmg")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value Publisher of the app.
     */
    @JvmName("gfaoevrqtbmmxbqp")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Setup file path.
     */
    @JvmName("fbbeyasdihujfuhh")
    public suspend fun setupFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.setupFile = mapped
    }

    /**
     * @param value Extract status.
     */
    @JvmName("ygiyxaixpjfpuvxe")
    public suspend fun status(`value`: Either<String, IntuneExtractStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Extract status.
     */
    @JvmName("rbxposocutjokmlb")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntuneExtractStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Extract status.
     */
    @JvmName("cmwjpavpibvtjywj")
    public fun status(`value`: IntuneExtractStatus) {
        val toBeMapped = Either.ofRight<String, IntuneExtractStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Uninstall command.
     */
    @JvmName("jqttidenbusfrybf")
    public suspend fun uninstallCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uninstallCommand = mapped
    }

    /**
     * @param value Intune app version.
     */
    @JvmName("yjtpgjjlmencvqfe")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DraftPackageIntuneAppMetadataItemArgs =
        DraftPackageIntuneAppMetadataItemArgs(
            appId = appId,
            appName = appName,
            createDate = createDate,
            dependencyIds = dependencyIds,
            dependentAppCount = dependentAppCount,
            description = description,
            expectedExitCodes = expectedExitCodes,
            installCommand = installCommand,
            lastProcessed = lastProcessed,
            minimumSupportedOS = minimumSupportedOS,
            owner = owner,
            publisher = publisher,
            setupFile = setupFile,
            status = status,
            uninstallCommand = uninstallCommand,
            version = version,
        )
}
