@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GalleryAppDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the definition of a gallery application used in Test Base package.
 * @property isConsented Whether the disclaimer of the gallery application is accepted.
 * @property skuId The SKU id of the gallery application.
 */
public data class GalleryAppDefinitionArgs(
    public val isConsented: Output<Boolean>? = null,
    public val skuId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GalleryAppDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GalleryAppDefinitionArgs =
        com.pulumi.azurenative.testbase.inputs.GalleryAppDefinitionArgs.builder()
            .isConsented(isConsented?.applyValue({ args0 -> args0 }))
            .skuId(skuId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryAppDefinitionArgs].
 */
@PulumiTagMarker
public class GalleryAppDefinitionArgsBuilder internal constructor() {
    private var isConsented: Output<Boolean>? = null

    private var skuId: Output<String>? = null

    /**
     * @param value Whether the disclaimer of the gallery application is accepted.
     */
    @JvmName("dvnvfsddqgqsqldl")
    public suspend fun isConsented(`value`: Output<Boolean>) {
        this.isConsented = value
    }

    /**
     * @param value The SKU id of the gallery application.
     */
    @JvmName("axslrawulpbnbebl")
    public suspend fun skuId(`value`: Output<String>) {
        this.skuId = value
    }

    /**
     * @param value Whether the disclaimer of the gallery application is accepted.
     */
    @JvmName("ksufgnkeupbhikej")
    public suspend fun isConsented(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isConsented = mapped
    }

    /**
     * @param value The SKU id of the gallery application.
     */
    @JvmName("iuifqgnbclrjtvxm")
    public suspend fun skuId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skuId = mapped
    }

    internal fun build(): GalleryAppDefinitionArgs = GalleryAppDefinitionArgs(
        isConsented = isConsented,
        skuId = skuId ?: throw PulumiNullFieldException("skuId"),
    )
}
