@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceFreeHourBalancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetBillingHubServiceFreeHourBalancePlainArgs(
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceFreeHourBalancePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceFreeHourBalancePlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceFreeHourBalancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBillingHubServiceFreeHourBalancePlainArgs].
 */
@PulumiTagMarker
public class GetBillingHubServiceFreeHourBalancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("uugpaaisualglqqi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("bcceitpjrptdkuic")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetBillingHubServiceFreeHourBalancePlainArgs =
        GetBillingHubServiceFreeHourBalancePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
        )
}
