@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetCustomerEventPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customerEventName The resource name of the Test Base Customer event.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetCustomerEventPlainArgs(
    public val customerEventName: String,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetCustomerEventPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GetCustomerEventPlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetCustomerEventPlainArgs.builder()
            .customerEventName(customerEventName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomerEventPlainArgs].
 */
@PulumiTagMarker
public class GetCustomerEventPlainArgsBuilder internal constructor() {
    private var customerEventName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The resource name of the Test Base Customer event.
     */
    @JvmName("hdhnlxfrphbjyflc")
    public suspend fun customerEventName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customerEventName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("krmvfucqcybghopb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("fdvwklsrtmjyoshb")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetCustomerEventPlainArgs = GetCustomerEventPlainArgs(
        customerEventName = customerEventName ?: throw PulumiNullFieldException("customerEventName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
    )
}
