@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetDraftPackagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property draftPackageName The resource name of the Test Base Draft Package.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetDraftPackagePlainArgs(
    public val draftPackageName: String,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetDraftPackagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GetDraftPackagePlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetDraftPackagePlainArgs.builder()
            .draftPackageName(draftPackageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDraftPackagePlainArgs].
 */
@PulumiTagMarker
public class GetDraftPackagePlainArgsBuilder internal constructor() {
    private var draftPackageName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The resource name of the Test Base Draft Package.
     */
    @JvmName("ubbirpdlrndwqvfo")
    public suspend fun draftPackageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.draftPackageName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qphcxailyskddxnj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("ummskwhpnnmnccri")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetDraftPackagePlainArgs = GetDraftPackagePlainArgs(
        draftPackageName = draftPackageName ?: throw PulumiNullFieldException("draftPackageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
    )
}
