@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.IntuneEnrollmentMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The metadata of Intune enrollment.
 * @property appList The enrolled Intune apps.
 * @property credentialId The id of the Intune enrollment credential.
 * @property expectedDeploymentDurationInMinute The expected duration of Intune applications and policies deployment.
 */
public data class IntuneEnrollmentMetadataArgs(
    public val appList: Output<List<EnrolledIntuneAppArgs>>? = null,
    public val credentialId: Output<String>? = null,
    public val expectedDeploymentDurationInMinute: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.IntuneEnrollmentMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.IntuneEnrollmentMetadataArgs =
        com.pulumi.azurenative.testbase.inputs.IntuneEnrollmentMetadataArgs.builder()
            .appList(
                appList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .credentialId(credentialId?.applyValue({ args0 -> args0 }))
            .expectedDeploymentDurationInMinute(
                expectedDeploymentDurationInMinute?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [IntuneEnrollmentMetadataArgs].
 */
@PulumiTagMarker
public class IntuneEnrollmentMetadataArgsBuilder internal constructor() {
    private var appList: Output<List<EnrolledIntuneAppArgs>>? = null

    private var credentialId: Output<String>? = null

    private var expectedDeploymentDurationInMinute: Output<Int>? = null

    /**
     * @param value The enrolled Intune apps.
     */
    @JvmName("broakgpnouwforup")
    public suspend fun appList(`value`: Output<List<EnrolledIntuneAppArgs>>) {
        this.appList = value
    }

    @JvmName("gawnfwqsgxcbmsdu")
    public suspend fun appList(vararg values: Output<EnrolledIntuneAppArgs>) {
        this.appList = Output.all(values.asList())
    }

    /**
     * @param values The enrolled Intune apps.
     */
    @JvmName("tmthqaesxbtdmogu")
    public suspend fun appList(values: List<Output<EnrolledIntuneAppArgs>>) {
        this.appList = Output.all(values)
    }

    /**
     * @param value The id of the Intune enrollment credential.
     */
    @JvmName("inesjippievwuoip")
    public suspend fun credentialId(`value`: Output<String>) {
        this.credentialId = value
    }

    /**
     * @param value The expected duration of Intune applications and policies deployment.
     */
    @JvmName("vkmiktgkkxbreook")
    public suspend fun expectedDeploymentDurationInMinute(`value`: Output<Int>) {
        this.expectedDeploymentDurationInMinute = value
    }

    /**
     * @param value The enrolled Intune apps.
     */
    @JvmName("igymvpjgjxerwumd")
    public suspend fun appList(`value`: List<EnrolledIntuneAppArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appList = mapped
    }

    /**
     * @param argument The enrolled Intune apps.
     */
    @JvmName("hunpswhffwcaqhdy")
    public suspend fun appList(argument: List<suspend EnrolledIntuneAppArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnrolledIntuneAppArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.appList = mapped
    }

    /**
     * @param argument The enrolled Intune apps.
     */
    @JvmName("eqpyjecxndcqxqfd")
    public suspend fun appList(vararg argument: suspend EnrolledIntuneAppArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnrolledIntuneAppArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.appList = mapped
    }

    /**
     * @param argument The enrolled Intune apps.
     */
    @JvmName("tjrjyyfsymyyivjw")
    public suspend fun appList(argument: suspend EnrolledIntuneAppArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnrolledIntuneAppArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.appList = mapped
    }

    /**
     * @param values The enrolled Intune apps.
     */
    @JvmName("bdlptrkssrfeslpa")
    public suspend fun appList(vararg values: EnrolledIntuneAppArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appList = mapped
    }

    /**
     * @param value The id of the Intune enrollment credential.
     */
    @JvmName("kofiqpdlshkojpfc")
    public suspend fun credentialId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialId = mapped
    }

    /**
     * @param value The expected duration of Intune applications and policies deployment.
     */
    @JvmName("qsigabgmdolbbflo")
    public suspend fun expectedDeploymentDurationInMinute(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedDeploymentDurationInMinute = mapped
    }

    internal fun build(): IntuneEnrollmentMetadataArgs = IntuneEnrollmentMetadataArgs(
        appList = appList,
        credentialId = credentialId,
        expectedDeploymentDurationInMinute = expectedDeploymentDurationInMinute,
    )
}
