@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.NotificationEventReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A notification event receivers.
 * @property receiverType The type of the notification event receiver.
 * @property receiverValue The notification event receiver value.
 */
public data class NotificationEventReceiverArgs(
    public val receiverType: Output<String>? = null,
    public val receiverValue: Output<NotificationReceiverValueArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.NotificationEventReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.NotificationEventReceiverArgs =
        com.pulumi.azurenative.testbase.inputs.NotificationEventReceiverArgs.builder()
            .receiverType(receiverType?.applyValue({ args0 -> args0 }))
            .receiverValue(receiverValue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NotificationEventReceiverArgs].
 */
@PulumiTagMarker
public class NotificationEventReceiverArgsBuilder internal constructor() {
    private var receiverType: Output<String>? = null

    private var receiverValue: Output<NotificationReceiverValueArgs>? = null

    /**
     * @param value The type of the notification event receiver.
     */
    @JvmName("ilqgiphwemrljuuh")
    public suspend fun receiverType(`value`: Output<String>) {
        this.receiverType = value
    }

    /**
     * @param value The notification event receiver value.
     */
    @JvmName("yccevbcmjjvsnwtv")
    public suspend fun receiverValue(`value`: Output<NotificationReceiverValueArgs>) {
        this.receiverValue = value
    }

    /**
     * @param value The type of the notification event receiver.
     */
    @JvmName("htehowldmgxvwuyx")
    public suspend fun receiverType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiverType = mapped
    }

    /**
     * @param value The notification event receiver value.
     */
    @JvmName("mgaxsfbcnywgxvqq")
    public suspend fun receiverValue(`value`: NotificationReceiverValueArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiverValue = mapped
    }

    /**
     * @param argument The notification event receiver value.
     */
    @JvmName("qcimasnpgynkvdie")
    public suspend
    fun receiverValue(argument: suspend NotificationReceiverValueArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationReceiverValueArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.receiverValue = mapped
    }

    internal fun build(): NotificationEventReceiverArgs = NotificationEventReceiverArgs(
        receiverType = receiverType,
        receiverValue = receiverValue,
    )
}
