@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.OsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of an operating system.
 * @property customImageId Specify the referenced Test Base Custom Image Id if available.
 * @property osName The name of the OS.
 * @property releaseProperties The properties of the OS release.
 */
public data class OsPropertiesArgs(
    public val customImageId: Output<String>? = null,
    public val osName: Output<String>? = null,
    public val releaseProperties: Output<ReleasePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.OsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.OsPropertiesArgs =
        com.pulumi.azurenative.testbase.inputs.OsPropertiesArgs.builder()
            .customImageId(customImageId?.applyValue({ args0 -> args0 }))
            .osName(osName?.applyValue({ args0 -> args0 }))
            .releaseProperties(
                releaseProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OsPropertiesArgs].
 */
@PulumiTagMarker
public class OsPropertiesArgsBuilder internal constructor() {
    private var customImageId: Output<String>? = null

    private var osName: Output<String>? = null

    private var releaseProperties: Output<ReleasePropertiesArgs>? = null

    /**
     * @param value Specify the referenced Test Base Custom Image Id if available.
     */
    @JvmName("salfloyskaolufje")
    public suspend fun customImageId(`value`: Output<String>) {
        this.customImageId = value
    }

    /**
     * @param value The name of the OS.
     */
    @JvmName("gttqgtiypjdchgpi")
    public suspend fun osName(`value`: Output<String>) {
        this.osName = value
    }

    /**
     * @param value The properties of the OS release.
     */
    @JvmName("hbdkwnkipjjmmopr")
    public suspend fun releaseProperties(`value`: Output<ReleasePropertiesArgs>) {
        this.releaseProperties = value
    }

    /**
     * @param value Specify the referenced Test Base Custom Image Id if available.
     */
    @JvmName("svkgruaijwuurlus")
    public suspend fun customImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImageId = mapped
    }

    /**
     * @param value The name of the OS.
     */
    @JvmName("kxbsggtbmfobdgeb")
    public suspend fun osName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osName = mapped
    }

    /**
     * @param value The properties of the OS release.
     */
    @JvmName("qhmhisoohkwyqnxl")
    public suspend fun releaseProperties(`value`: ReleasePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseProperties = mapped
    }

    /**
     * @param argument The properties of the OS release.
     */
    @JvmName("jaiginvanaytiwdx")
    public suspend fun releaseProperties(argument: suspend ReleasePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ReleasePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.releaseProperties = mapped
    }

    internal fun build(): OsPropertiesArgs = OsPropertiesArgs(
        customImageId = customImageId,
        osName = osName,
        releaseProperties = releaseProperties,
    )
}
