@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.TabStateArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.PackageStudioTabs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies current state of tabs.
 * @property currentTab Current tab.
 * @property visitedTabs visited tabs.
 */
public data class TabStateArgs(
    public val currentTab: Output<Either<String, PackageStudioTabs>>? = null,
    public val visitedTabs: Output<List<Either<String, PackageStudioTabs>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.TabStateArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.TabStateArgs =
        com.pulumi.azurenative.testbase.inputs.TabStateArgs.builder()
            .currentTab(
                currentTab?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .visitedTabs(
                visitedTabs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            ).build()
}

/**
 * Builder for [TabStateArgs].
 */
@PulumiTagMarker
public class TabStateArgsBuilder internal constructor() {
    private var currentTab: Output<Either<String, PackageStudioTabs>>? = null

    private var visitedTabs: Output<List<Either<String, PackageStudioTabs>>>? = null

    /**
     * @param value Current tab.
     */
    @JvmName("bumgmlfuwpoxmcpk")
    public suspend fun currentTab(`value`: Output<Either<String, PackageStudioTabs>>) {
        this.currentTab = value
    }

    /**
     * @param value visited tabs.
     */
    @JvmName("namoycyrrebdjywo")
    public suspend fun visitedTabs(`value`: Output<List<Either<String, PackageStudioTabs>>>) {
        this.visitedTabs = value
    }

    @JvmName("tkwyjedwlamwxglo")
    public suspend fun visitedTabs(vararg values: Output<Either<String, PackageStudioTabs>>) {
        this.visitedTabs = Output.all(values.asList())
    }

    /**
     * @param values visited tabs.
     */
    @JvmName("tsvaciibpfqhuyfr")
    public suspend fun visitedTabs(values: List<Output<Either<String, PackageStudioTabs>>>) {
        this.visitedTabs = Output.all(values)
    }

    /**
     * @param value Current tab.
     */
    @JvmName("iaiiagxbaifokvdp")
    public suspend fun currentTab(`value`: Either<String, PackageStudioTabs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentTab = mapped
    }

    /**
     * @param value Current tab.
     */
    @JvmName("kqrapmaiyqjlpajf")
    public fun currentTab(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PackageStudioTabs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currentTab = mapped
    }

    /**
     * @param value Current tab.
     */
    @JvmName("xhbjkrhfpcpeaqhw")
    public fun currentTab(`value`: PackageStudioTabs) {
        val toBeMapped = Either.ofRight<String, PackageStudioTabs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currentTab = mapped
    }

    /**
     * @param value visited tabs.
     */
    @JvmName("unqrrwnrwggyjuju")
    public suspend fun visitedTabs(`value`: List<Either<String, PackageStudioTabs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visitedTabs = mapped
    }

    /**
     * @param values visited tabs.
     */
    @JvmName("msfqcxaxvouphhyg")
    public suspend fun visitedTabs(vararg values: Either<String, PackageStudioTabs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visitedTabs = mapped
    }

    internal fun build(): TabStateArgs = TabStateArgs(
        currentTab = currentTab,
        visitedTabs = visitedTabs,
    )
}
