@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.TestArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.TestType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The definition of a Test.
 * @property commands The commands used in the test.
 * @property isActive Indicates if this test is active.It doesn't schedule test for not active Test.
 * @property testType The type of the test.
 */
public data class TestArgs(
    public val commands: Output<List<CommandArgs>>,
    public val isActive: Output<Boolean>? = null,
    public val testType: Output<Either<String, TestType>>,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.TestArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.TestArgs =
        com.pulumi.azurenative.testbase.inputs.TestArgs.builder()
            .commands(
                commands.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isActive(isActive?.applyValue({ args0 -> args0 }))
            .testType(
                testType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [TestArgs].
 */
@PulumiTagMarker
public class TestArgsBuilder internal constructor() {
    private var commands: Output<List<CommandArgs>>? = null

    private var isActive: Output<Boolean>? = null

    private var testType: Output<Either<String, TestType>>? = null

    /**
     * @param value The commands used in the test.
     */
    @JvmName("vpcwvpblnphwgcrb")
    public suspend fun commands(`value`: Output<List<CommandArgs>>) {
        this.commands = value
    }

    @JvmName("eilveuhqawomgwlh")
    public suspend fun commands(vararg values: Output<CommandArgs>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values The commands used in the test.
     */
    @JvmName("oyaeeughnunconok")
    public suspend fun commands(values: List<Output<CommandArgs>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Indicates if this test is active.It doesn't schedule test for not active Test.
     */
    @JvmName("hfthugognajsgshe")
    public suspend fun isActive(`value`: Output<Boolean>) {
        this.isActive = value
    }

    /**
     * @param value The type of the test.
     */
    @JvmName("yxiypawrksrsgbfo")
    public suspend fun testType(`value`: Output<Either<String, TestType>>) {
        this.testType = value
    }

    /**
     * @param value The commands used in the test.
     */
    @JvmName("ekgoxfboiyiwstvl")
    public suspend fun commands(`value`: List<CommandArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param argument The commands used in the test.
     */
    @JvmName("yuwaicpfabcpusnd")
    public suspend fun commands(argument: List<suspend CommandArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CommandArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.commands = mapped
    }

    /**
     * @param argument The commands used in the test.
     */
    @JvmName("wcicxdvdafpcxjpi")
    public suspend fun commands(vararg argument: suspend CommandArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CommandArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.commands = mapped
    }

    /**
     * @param argument The commands used in the test.
     */
    @JvmName("gysymxiykknwynyf")
    public suspend fun commands(argument: suspend CommandArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CommandArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.commands = mapped
    }

    /**
     * @param values The commands used in the test.
     */
    @JvmName("yftwgiqtccawbeqa")
    public suspend fun commands(vararg values: CommandArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value Indicates if this test is active.It doesn't schedule test for not active Test.
     */
    @JvmName("gouyewymhkpecoac")
    public suspend fun isActive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isActive = mapped
    }

    /**
     * @param value The type of the test.
     */
    @JvmName("xlcidrtnqutcghdu")
    public suspend fun testType(`value`: Either<String, TestType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testType = mapped
    }

    /**
     * @param value The type of the test.
     */
    @JvmName("cxjffwhfmaqeuoqn")
    public fun testType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TestType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testType = mapped
    }

    /**
     * @param value The type of the test.
     */
    @JvmName("rxmxuxisdvlqfgrl")
    public fun testType(`value`: TestType) {
        val toBeMapped = Either.ofRight<String, TestType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testType = mapped
    }

    internal fun build(): TestArgs = TestArgs(
        commands = commands ?: throw PulumiNullFieldException("commands"),
        isActive = isActive,
        testType = testType ?: throw PulumiNullFieldException("testType"),
    )
}
