@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property totalCharges
 * @property totalUsedBillableHours
 * @property totalUsedFreeHours
 * @property updateType
 * @property usageGroups
 */
public data class BillingHubUsageGroupedByUpdateTypeResponse(
    public val totalCharges: Double? = null,
    public val totalUsedBillableHours: Double? = null,
    public val totalUsedFreeHours: Double? = null,
    public val updateType: String? = null,
    public val usageGroups: List<BillingHubUsageGroupResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.BillingHubUsageGroupedByUpdateTypeResponse):
            BillingHubUsageGroupedByUpdateTypeResponse = BillingHubUsageGroupedByUpdateTypeResponse(
            totalCharges = javaType.totalCharges().map({ args0 -> args0 }).orElse(null),
            totalUsedBillableHours = javaType.totalUsedBillableHours().map({ args0 -> args0 }).orElse(null),
            totalUsedFreeHours = javaType.totalUsedFreeHours().map({ args0 -> args0 }).orElse(null),
            updateType = javaType.updateType().map({ args0 -> args0 }).orElse(null),
            usageGroups = javaType.usageGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.BillingHubUsageGroupResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
