@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The metadata of Intune app(s) used for generation.
 * @property intuneApp The Metadata of the Intune App through intunewin file uploading.
 * @property intuneAppDependencies The Metadata of dependencies of the Intune App through intunewin file uploading.
 */
public data class DraftPackageIntuneAppMetadataResponse(
    public val intuneApp: DraftPackageIntuneAppMetadataItemResponse? = null,
    public val intuneAppDependencies: List<DraftPackageIntuneAppMetadataItemResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.DraftPackageIntuneAppMetadataResponse):
            DraftPackageIntuneAppMetadataResponse = DraftPackageIntuneAppMetadataResponse(
            intuneApp = javaType.intuneApp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.DraftPackageIntuneAppMetadataItemResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            intuneAppDependencies = javaType.intuneAppDependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.DraftPackageIntuneAppMetadataItemResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
