@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the definition of a first party application of the Test Base package.
 * @property architecture The architecture of a first party application of a Test Base Account.
 * @property channel The channel info of a first party application of a Test Base Account.
 * @property interopExecutionMode Specifies how the first party applications should be inter-operated with user's application.
 * @property name The media name of a first party application of a Test Base Account.
 * @property ring The ring info of a first party application of a Test Base Account.
 */
public data class FirstPartyAppDefinitionResponse(
    public val architecture: String? = null,
    public val channel: String? = null,
    public val interopExecutionMode: String? = null,
    public val name: String? = null,
    public val ring: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.FirstPartyAppDefinitionResponse):
            FirstPartyAppDefinitionResponse = FirstPartyAppDefinitionResponse(
            architecture = javaType.architecture().map({ args0 -> args0 }).orElse(null),
            channel = javaType.channel().map({ args0 -> args0 }).orElse(null),
            interopExecutionMode = javaType.interopExecutionMode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ring = javaType.ring().map({ args0 -> args0 }).orElse(null),
        )
    }
}
