@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Properties of the definition of a gallery application used in Test Base package.
 * @property isConsented Whether the disclaimer of the gallery application is accepted.
 * @property skuId The SKU id of the gallery application.
 */
public data class GalleryAppDefinitionResponse(
    public val isConsented: Boolean? = null,
    public val skuId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GalleryAppDefinitionResponse):
            GalleryAppDefinitionResponse = GalleryAppDefinitionResponse(
            isConsented = javaType.isConsented().map({ args0 -> args0 }).orElse(null),
            skuId = javaType.skuId(),
        )
    }
}
