@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property creationDate
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property preReleaseAccessRequestSpec
 * @property provisioningState The provisioning state of the resource.
 * @property requestType
 * @property status
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetActionRequestResult(
    public val creationDate: String,
    public val id: String,
    public val name: String,
    public val preReleaseAccessRequestSpec: PreReleaseAccessRequestSpecResponse? = null,
    public val provisioningState: String,
    public val requestType: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetActionRequestResult):
            GetActionRequestResult = GetActionRequestResult(
            creationDate = javaType.creationDate(),
            id = javaType.id(),
            name = javaType.name(),
            preReleaseAccessRequestSpec = javaType.preReleaseAccessRequestSpec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.PreReleaseAccessRequestSpecResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            requestType = javaType.requestType(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
