@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Customer Notification Event resource.
 * @property eventName The name of the event subscribed to.
 * @property id Resource ID.
 * @property name Resource name.
 * @property receivers The notification event receivers.
 * @property systemData The system metadata relating to this resource
 * @property type Resource type.
 */
public data class GetCustomerEventResult(
    public val eventName: String,
    public val id: String,
    public val name: String,
    public val receivers: List<NotificationEventReceiverResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetCustomerEventResult):
            GetCustomerEventResult = GetCustomerEventResult(
            eventName = javaType.eventName(),
            id = javaType.id(),
            name = javaType.name(),
            receivers = javaType.receivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.NotificationEventReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
